/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.as7;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.keycloak.subsystem.server.as7.KeycloakSubsystemDefinition;
import org.keycloak.subsystem.server.as7.KeycloakSubsystemParser;
import org.keycloak.subsystem.server.logging.KeycloakLogger;

public class KeycloakExtension
implements Extension {
    static final String SUBSYSTEM_NAME = "keycloak-server";
    static final String NAMESPACE = "urn:jboss:domain:keycloak-server:1.1";
    static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"keycloak-server");
    private static final String RESOURCE_NAME = KeycloakExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ResourceDefinition KEYCLOAK_SUBSYSTEM_RESOURCE = new KeycloakSubsystemDefinition();
    private static final KeycloakSubsystemParser PARSER = new KeycloakSubsystemParser();
    private static final int MGMT_API_VERSION_MAJOR = 1;
    private static final int MGMT_API_VERSION_MINOR = 1;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, KeycloakExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)PARSER);
    }

    public void initialize(ExtensionContext context) {
        KeycloakLogger.ROOT_LOGGER.debug("Activating Keycloak Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1);
        subsystem.registerSubsystemModel(KEYCLOAK_SUBSYSTEM_RESOURCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
    }
}

