/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class CopyDependencies {
    private final String version;
    private final Path targetDir;
    private final Path projectDir;
    private final Path mavenRepository;

    public static void main(String[] args) throws IOException {
        String version = args[2];
        Path targetRoot = new File(args[1]).toPath().resolve(version);
        Path projectDir = targetRoot.getParent().getParent().getParent().getParent();
        Path mavenRepository = new File(args[0]).toPath().resolve("org").resolve("keycloak");
        CopyDependencies dependencies = new CopyDependencies(version, projectDir, targetRoot, mavenRepository);
        dependencies.copyFiles();
    }

    public CopyDependencies(String version, Path projectDir, Path targetDir, Path mavenRepository) {
        this.version = version;
        this.targetDir = targetDir;
        this.projectDir = projectDir;
        this.mavenRepository = mavenRepository;
    }

    public void copyFiles() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(CopyDependencies.class.getResourceAsStream("files")));
        this.targetDir.toFile().mkdirs();
        String l = br.readLine();
        while (l != null) {
            if (l.trim().length() > 0) {
                l = this.replaceVariables(l);
                String[] t = l.trim().split(":");
                String type = t[0];
                String artifactName = t[1];
                String destinationName = t.length == 2 ? artifactName : t[2];
                switch (type) {
                    case "mvn": {
                        this.copyMaven(artifactName, destinationName);
                        break;
                    }
                    case "npm": {
                        this.copyNpm(artifactName, destinationName);
                    }
                }
            }
            l = br.readLine();
        }
        br.close();
    }

    private void copyMaven(String artifactName, String destinationName) throws IOException {
        File[] files;
        File artifactDir = this.mavenRepository.resolve(artifactName).resolve(this.version).toFile();
        if (!artifactDir.isDirectory()) {
            throw new RuntimeException(artifactName + " (" + String.valueOf(artifactDir) + ") not found");
        }
        for (File f : files = artifactDir.listFiles((file, name) -> name.contains(".tar.gz") || name.contains(".tgz") || name.contains(".zip"))) {
            Files.copy(f.toPath(), this.targetDir.resolve(f.getName().replace(artifactName, destinationName)), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void copyNpm(String artifactName, String destinationName) throws IOException {
        Path artifactPath = this.projectDir.resolve(artifactName);
        if (!artifactPath.toFile().isFile()) {
            throw new RuntimeException(artifactName + " (" + String.valueOf(artifactPath) + ") not found");
        }
        Files.copy(this.projectDir.resolve(artifactName), this.targetDir.resolve(destinationName), new CopyOption[0]);
    }

    private String replaceVariables(String input) {
        return input.replaceAll("\\$\\$VERSION\\$\\$", this.version);
    }
}

