/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.elytron;

import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.UserIdentityExtractor;
import org.keycloak.common.crypto.UserIdentityExtractorProvider;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.OidsUtil;
import org.wildfly.security.x500.principal.X500AttributePrincipalDecoder;

public class ElytronUserIdentityExtractorProvider
extends UserIdentityExtractorProvider {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public UserIdentityExtractor getX500NameExtractor(String identifier, Function<X509Certificate[], Principal> x500Name) {
        return new X500NameRDNExtractorElytronProvider(identifier, x500Name);
    }

    public UserIdentityExtractorProvider.SubjectAltNameExtractor getSubjectAltNameExtractor(int generalName) {
        return new SubjectAltNameExtractorEltronProvider(generalName);
    }

    class X500NameRDNExtractorElytronProvider
    extends UserIdentityExtractorProvider.X500NameRDNExtractor {
        private String x500NameStyle;
        Function<X509Certificate[], Principal> x500Name;

        public X500NameRDNExtractorElytronProvider(String attrName, Function<X509Certificate[], Principal> x500Name) {
            super((UserIdentityExtractorProvider)ElytronUserIdentityExtractorProvider.this);
            if (attrName.equals("EmailAddress")) {
                attrName = "E";
            }
            this.x500NameStyle = OidsUtil.attributeNameToOid((OidsUtil.Category)OidsUtil.Category.RDN, (String)attrName);
            ElytronUserIdentityExtractorProvider.this.log.debug((Object)("Attribute Name: " + attrName + " X500NameStyle OID: " + this.x500NameStyle));
            this.x500Name = x500Name;
        }

        public Object extractUserIdentity(X509Certificate[] certs) {
            if (certs == null || certs.length == 0) {
                throw new IllegalArgumentException();
            }
            Principal name = this.x500Name.apply(certs);
            ElytronUserIdentityExtractorProvider.this.log.debug((Object)("Principal Name " + name.getName()));
            X500AttributePrincipalDecoder xDecoder = new X500AttributePrincipalDecoder(this.x500NameStyle);
            String cn = xDecoder.apply(name);
            return cn;
        }
    }

    class SubjectAltNameExtractorEltronProvider
    extends UserIdentityExtractorProvider.SubjectAltNameExtractor {
        private static final String UPN_OID = "1.3.6.1.4.1.311.20.2.3";
        private final int generalName;

        SubjectAltNameExtractorEltronProvider(int generalName) {
            super((UserIdentityExtractorProvider)ElytronUserIdentityExtractorProvider.this);
            this.generalName = generalName;
        }

        public Object extractUserIdentity(X509Certificate[] certs) {
            if (certs == null || certs.length == 0) {
                throw new IllegalArgumentException();
            }
            String subjectName = null;
            ElytronUserIdentityExtractorProvider.this.log.debug((Object)("SubjPrinc " + String.valueOf(certs[0].getSubjectX500Principal())));
            try {
                Collection<List<?>> subjectAlternativeNames = certs[0].getSubjectAlternativeNames();
                if (subjectAlternativeNames == null) {
                    return null;
                }
                Iterator<List<?>> iterator = subjectAlternativeNames.iterator();
                boolean upnOidFound = false;
                ElytronUserIdentityExtractorProvider.this.log.debug((Object)Arrays.toString(subjectAlternativeNames.toArray()));
                while (iterator.hasNext() && !upnOidFound) {
                    List<?> sbjAltName = iterator.next();
                    Integer nameType = (Integer)sbjAltName.get(0);
                    if (nameType != this.generalName) continue;
                    block12: for (int i = 1; i < sbjAltName.size(); ++i) {
                        Object obj = sbjAltName.get(i);
                        if (this.generalName != 0) {
                            ElytronUserIdentityExtractorProvider.this.log.tracef("Extracted identity '%s' from Subject Alternative Name of type '%d'", obj, (Object)this.generalName);
                            return obj;
                        }
                        if (!(obj instanceof byte[])) continue;
                        byte[] otherNameBytes = (byte[])obj;
                        DERDecoder derDecoder = new DERDecoder(otherNameBytes);
                        derDecoder.startSequence();
                        block13: while (derDecoder.hasNextElement() && !upnOidFound) {
                            int asn1Type = derDecoder.peekType();
                            ElytronUserIdentityExtractorProvider.this.log.debug((Object)("ASN.1 Type: " + derDecoder.peekType()));
                            switch (asn1Type) {
                                case 6: {
                                    String oid = derDecoder.decodeObjectIdentifier();
                                    ElytronUserIdentityExtractorProvider.this.log.debug((Object)("OID: " + oid));
                                    if (!UPN_OID.equals(oid)) continue block13;
                                    derDecoder.decodeImplicit(160);
                                    byte[] sb = derDecoder.drainElementValue();
                                    while (!Character.isLetterOrDigit(sb[0])) {
                                        sb = Arrays.copyOfRange(sb, 1, sb.length);
                                    }
                                    subjectName = new String(sb, StandardCharsets.UTF_8);
                                    upnOidFound = true;
                                    continue block13;
                                }
                                case 12: {
                                    subjectName = derDecoder.decodeUtf8String();
                                    continue block13;
                                }
                                case 19: {
                                    subjectName = derDecoder.decodePrintableString();
                                    continue block13;
                                }
                                case 28: {
                                    subjectName = derDecoder.decodeUniversalString();
                                    continue block13;
                                }
                                case 4: {
                                    subjectName = derDecoder.decodeOctetStringAsString();
                                    continue block13;
                                }
                                case 160: {
                                    derDecoder.startExplicit(asn1Type);
                                    continue block13;
                                }
                                case 48: {
                                    continue block12;
                                }
                                default: {
                                    derDecoder.skipElement();
                                    continue block13;
                                }
                            }
                        }
                    }
                }
            }
            catch (CertificateParsingException e) {
                ElytronUserIdentityExtractorProvider.this.log.error((Object)"Failed to parse Subject Name:", (Throwable)e);
            }
            ElytronUserIdentityExtractorProvider.this.log.debug((Object)("Subject Alt Name: " + subjectName));
            return subjectName;
        }
    }
}

