/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.elytron;

import java.security.Key;
import javax.crypto.Cipher;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;

public class ElytronRsaKeyEncryptionJWEAlgorithmProvider
implements JWEAlgorithmProvider {
    private final String jcaAlgorithmName;

    public ElytronRsaKeyEncryptionJWEAlgorithmProvider(String jcaAlgorithmName) {
        this.jcaAlgorithmName = jcaAlgorithmName;
    }

    public byte[] decodeCek(byte[] encodedCek, Key privateKey, JWEHeader header, JWEEncryptionProvider encryptionProvider) throws Exception {
        Cipher cipher = this.getCipherProvider();
        this.initCipher(cipher, 2, privateKey);
        return cipher.doFinal(encodedCek);
    }

    public byte[] encodeCek(JWEEncryptionProvider encryptionProvider, JWEKeyStorage keyStorage, Key publicKey, JWEHeader.JWEHeaderBuilder headerBuilder) throws Exception {
        Cipher cipher = this.getCipherProvider();
        this.initCipher(cipher, 1, publicKey);
        byte[] cekBytes = keyStorage.getCekBytes();
        return cipher.doFinal(cekBytes);
    }

    private Cipher getCipherProvider() throws Exception {
        return Cipher.getInstance(this.jcaAlgorithmName);
    }

    protected void initCipher(Cipher cipher, int mode, Key key) throws Exception {
        cipher.init(mode, key);
    }
}

