/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.elytron;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.PemUtilsProvider;
import org.keycloak.common.util.DerUtils;
import org.keycloak.common.util.PemException;

public class ElytronPEMUtilsProvider
extends PemUtilsProvider {
    Logger log = Logger.getLogger(ElytronPEMUtilsProvider.class);

    protected String encode(Object obj) {
        String encoded = null;
        if (obj instanceof Key) {
            byte[] b = ((Key)obj).getEncoded();
            encoded = Base64.getEncoder().encodeToString(b);
        } else if (obj instanceof Certificate) {
            try {
                byte[] c = ((Certificate)obj).getEncoded();
                encoded = Base64.getEncoder().encodeToString(c);
            }
            catch (CertificateEncodingException e) {
                this.log.warn((Object)"Failed to encoded certificate.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return encoded;
    }

    public PrivateKey decodePrivateKey(String pem) {
        if (pem == null) {
            return null;
        }
        try {
            byte[] der = this.pemToDer(pem);
            return DerUtils.decodePrivateKey((byte[])der);
        }
        catch (Exception e) {
            throw new PemException((Throwable)e);
        }
    }
}

