/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.elytron;

import java.io.IOException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLReason;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.utils.OCSPProvider;
import org.wildfly.security.asn1.DERDecoder;

public class ElytronOCSPProvider
extends OCSPProvider {
    private static final Logger logger = Logger.getLogger((String)ElytronOCSPProvider.class.getName());

    protected OCSPProvider.OCSPRevocationStatus check(KeycloakSession session, X509Certificate cert, X509Certificate issuerCertificate, List<URI> responderURIs, X509Certificate responderCert, Date date) throws CertPathValidatorException {
        if (responderURIs == null || responderURIs.size() == 0) {
            throw new IllegalArgumentException("Need at least one responder");
        }
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, "pass".toCharArray());
            trustStore.setCertificateEntry("trust", issuerCertificate);
            CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
            PKIXRevocationChecker rc = (PKIXRevocationChecker)cpb.getRevocationChecker();
            X509CertSelector certSelector = new X509CertSelector();
            X509Certificate[] certs = new X509Certificate[]{cert};
            certSelector.setCertificate(cert);
            certSelector.setCertificateValid(date);
            CertPath cp = cf.generateCertPath(Arrays.asList(certs));
            PKIXBuilderParameters params = new PKIXBuilderParameters(trustStore, (CertSelector)certSelector);
            rc.setOcspResponder(responderURIs.get(0));
            rc.setOcspResponderCert(responderCert);
            rc.setOptions(EnumSet.noneOf(PKIXRevocationChecker.Option.class));
            params.setRevocationEnabled(false);
            params.addCertPathChecker(rc);
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(cp, params);
            logger.debug((Object)("Certificate validated by CA: " + result.getTrustAnchor().getCAName()));
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.warn((Object)"OSCP Response check failed.", (Throwable)e);
            return ElytronOCSPProvider.unknownStatus();
        }
        return new OCSPProvider.OCSPRevocationStatus(){

            public OCSPProvider.RevocationStatus getRevocationStatus() {
                return OCSPProvider.RevocationStatus.GOOD;
            }

            public Date getRevocationTime() {
                return null;
            }

            public CRLReason getRevocationReason() {
                return null;
            }
        };
    }

    protected List<String> getResponderURIs(X509Certificate cert) throws CertificateEncodingException {
        LinkedList<String> responderURIs = new LinkedList<String>();
        byte[] authinfob = cert.getExtensionValue("1.3.6.1.5.5.7.1.1");
        DERDecoder der = new DERDecoder(authinfob);
        der = new DERDecoder(der.decodeOctetString());
        block7: while (der.hasNextElement()) {
            switch (der.peekType()) {
                case 48: {
                    der.startSequence();
                    continue block7;
                }
                case 6: {
                    String oid = der.decodeObjectIdentifier();
                    if (!"1.3.6.1.5.5.7.48.1".equals(oid)) continue block7;
                    byte[] uri = der.drainElementValue();
                    responderURIs.add(new String(uri));
                    continue block7;
                }
                case 22: {
                    continue block7;
                }
                case 12: {
                    responderURIs.add(der.decodeUtf8String());
                    continue block7;
                }
                case 160: {
                    der.decodeImplicit(160);
                    byte[] edata = der.decodeOctetString();
                    while (!Character.isLetterOrDigit(edata[0])) {
                        edata = Arrays.copyOfRange(edata, 1, edata.length);
                    }
                    responderURIs.add(new String(edata));
                    continue block7;
                }
            }
            der.skipElement();
        }
        logger.warn((Object)("OCSP Responder URIs" + Arrays.toString(responderURIs.toArray())));
        return responderURIs;
    }
}

