/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.elytron;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.net.ssl.SSLSocketFactory;
import org.keycloak.common.crypto.CertificateUtilsProvider;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.common.crypto.ECDSACryptoProvider;
import org.keycloak.common.crypto.PemUtilsProvider;
import org.keycloak.common.crypto.UserIdentityExtractorProvider;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.elytron.AesKeyWrapAlgorithmProvider;
import org.keycloak.crypto.elytron.ElytronCertificateUtilsProvider;
import org.keycloak.crypto.elytron.ElytronECDSACryptoProvider;
import org.keycloak.crypto.elytron.ElytronEcdhEsAlgorithmProvider;
import org.keycloak.crypto.elytron.ElytronOCSPProvider;
import org.keycloak.crypto.elytron.ElytronPEMUtilsProvider;
import org.keycloak.crypto.elytron.ElytronRsaKeyEncryption256JWEAlgorithmProvider;
import org.keycloak.crypto.elytron.ElytronRsaKeyEncryptionJWEAlgorithmProvider;
import org.keycloak.crypto.elytron.ElytronUserIdentityExtractorProvider;

public class WildFlyElytronProvider
implements CryptoProvider {
    private Map<String, Object> providers = new ConcurrentHashMap<String, Object>();

    public WildFlyElytronProvider() {
        this.providers.put("A128KW", new AesKeyWrapAlgorithmProvider());
        this.providers.put("RSA1_5", new ElytronRsaKeyEncryptionJWEAlgorithmProvider("RSA/ECB/PKCS1Padding"));
        this.providers.put("RSA-OAEP", new ElytronRsaKeyEncryptionJWEAlgorithmProvider("RSA/ECB/OAEPWithSHA-1AndMGF1Padding"));
        this.providers.put("RSA-OAEP-256", new ElytronRsaKeyEncryption256JWEAlgorithmProvider("RSA/ECB/OAEPWithSHA-256AndMGF1Padding"));
        this.providers.put("ECDH-ES", new ElytronEcdhEsAlgorithmProvider());
        this.providers.put("ECDH-ES+A128KW", new ElytronEcdhEsAlgorithmProvider());
        this.providers.put("ECDH-ES+A192KW", new ElytronEcdhEsAlgorithmProvider());
        this.providers.put("ECDH-ES+A256KW", new ElytronEcdhEsAlgorithmProvider());
    }

    public Provider getBouncyCastleProvider() {
        return null;
    }

    public int order() {
        return 200;
    }

    public <T> T getAlgorithmProvider(Class<T> clazz, String algorithm) {
        Object o = this.providers.get(algorithm);
        if (o == null) {
            throw new IllegalArgumentException("Not found provider of algorithm type: " + algorithm);
        }
        return clazz.cast(o);
    }

    public CertificateUtilsProvider getCertificateUtils() {
        return new ElytronCertificateUtilsProvider();
    }

    public PemUtilsProvider getPemUtils() {
        return new ElytronPEMUtilsProvider();
    }

    public <T> T getOCSPProver(Class<T> clazz) {
        return clazz.cast((Object)new ElytronOCSPProvider());
    }

    public UserIdentityExtractorProvider getIdentityExtractorProvider() {
        return new ElytronUserIdentityExtractorProvider();
    }

    public ECDSACryptoProvider getEcdsaCryptoProvider() {
        return new ElytronECDSACryptoProvider();
    }

    public ECParameterSpec createECParams(String curveName) {
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance("EC");
            params.init(new ECGenParameterSpec(curveName));
            return params.getParameterSpec(ECParameterSpec.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate EC parameter spec", e);
        }
    }

    public KeyPairGenerator getKeyPairGen(String algorithm) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(algorithm);
    }

    public KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        if ("ECDSA".equals(algorithm)) {
            algorithm = "EC";
        }
        return KeyFactory.getInstance(algorithm);
    }

    public Cipher getAesCbcCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("AES/CBC/PKCS5Padding");
    }

    public Cipher getAesGcmCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("AES/GCM/NoPadding");
    }

    public SecretKeyFactory getSecretKeyFact(String keyAlgorithm) throws NoSuchAlgorithmException {
        return SecretKeyFactory.getInstance(keyAlgorithm);
    }

    public KeyStore getKeyStore(KeystoreUtil.KeystoreFormat format) throws KeyStoreException {
        return KeyStore.getInstance(format.toString());
    }

    public CertificateFactory getX509CertFactory() throws CertificateException {
        return CertificateFactory.getInstance("X.509");
    }

    public CertStore getCertStore(CollectionCertStoreParameters certStoreParams) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        return CertStore.getInstance("Collection", certStoreParams);
    }

    public CertPathBuilder getCertPathBuilder() throws NoSuchAlgorithmException {
        return CertPathBuilder.getInstance("PKIX");
    }

    public Signature getSignature(String sigAlgName) throws NoSuchAlgorithmException {
        String javaAlgorithm;
        switch (javaAlgorithm = JavaAlgorithm.getJavaAlgorithm((String)sigAlgName)) {
            case "SHA256withRSAandMGF1": 
            case "SHA384withRSAandMGF1": 
            case "SHA512withRSAandMGF1": {
                Signature signature = Signature.getInstance("RSASSA-PSS");
                int digestLength = Integer.parseInt(javaAlgorithm.substring(3, 6));
                MGF1ParameterSpec ps = new MGF1ParameterSpec("SHA-" + digestLength);
                PSSParameterSpec params = new PSSParameterSpec(ps.getDigestAlgorithm(), "MGF1", ps, digestLength / 8, 1);
                try {
                    signature.setParameter(params);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new RuntimeException(e);
                }
                return signature;
            }
        }
        return Signature.getInstance(javaAlgorithm);
    }

    public SSLSocketFactory wrapFactoryForTruststore(SSLSocketFactory delegate) {
        return delegate;
    }
}

