/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.EdECPoint;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.jwk.AbstractJWKParser;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.util.JsonSerialization;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JWKParser
extends AbstractJWKParser {
    private JWKParser() {
    }

    public static JWKParser create() {
        return new JWKParser();
    }

    public JWKParser(JWK jwk) {
        this.jwk = jwk;
    }

    public static JWKParser create(JWK jwk) {
        return new JWKParser(jwk);
    }

    public JWKParser parse(String jwk) {
        try {
            this.jwk = (JWK)JsonSerialization.mapper.readValue(jwk, JWK.class);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PublicKey toPublicKey() {
        if (this.jwk == null) {
            throw new IllegalStateException("Not possible to convert to the publicKey. The jwk is not set");
        }
        String keyType = this.jwk.getKeyType();
        if ("RSA".equals(keyType)) {
            return this.createRSAPublicKey();
        }
        if ("EC".equals(keyType)) {
            return this.createECPublicKey();
        }
        if ("OKP".equals(keyType)) {
            return this.createOKPPublicKey();
        }
        throw new RuntimeException("Unsupported keyType " + keyType);
    }

    private PublicKey createOKPPublicKey() {
        String x = (String)this.jwk.getOtherClaims().get("x");
        String crv = (String)this.jwk.getOtherClaims().get("crv");
        int bytesLength = 0;
        if ("Ed25519".equals(crv)) {
            bytesLength = 32;
        } else if ("Ed448".equals(crv)) {
            bytesLength = 57;
        } else {
            throw new RuntimeException("Invalid JWK representation of OKP type algorithm");
        }
        byte[] decodedX = Base64Url.decode((String)x);
        if (decodedX.length != bytesLength) {
            throw new RuntimeException("Invalid JWK representation of OKP type public key");
        }
        boolean isOddX = false;
        if ((decodedX[decodedX.length - 1] & 0xFFFFFF80) != 0) {
            isOddX = true;
        }
        int n = decodedX.length - 1;
        decodedX[n] = (byte)(decodedX[n] & 0x7F);
        BigInteger y = new BigInteger(1, JWKBuilder.reverseBytes(decodedX));
        NamedParameterSpec spec = new NamedParameterSpec(crv);
        EdECPoint ep = new EdECPoint(isOddX, y);
        EdECPublicKeySpec keySpec = new EdECPublicKeySpec(spec, ep);
        PublicKey publicKey = null;
        try {
            publicKey = KeyFactory.getInstance(crv).generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        return publicKey;
    }

    @Override
    public boolean isKeyTypeSupported(String keyType) {
        return "RSA".equals(keyType) || "EC".equals(keyType) || "OKP".equals(keyType);
    }
}

