/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.io.IOException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.RefreshToken;
import org.keycloak.util.JsonSerialization;

public class TokenUtil {
    public static final String TOKEN_TYPE_BEARER = "Bearer";
    public static final String TOKEN_TYPE_ID = "ID";
    public static final String TOKEN_TYPE_REFRESH = "Refresh";
    public static final String TOKEN_TYPE_OFFLINE = "Offline";

    public static boolean isOfflineTokenRequested(String scopeParam) {
        String[] scopes;
        if (scopeParam == null) {
            return false;
        }
        for (String scope : scopes = scopeParam.split(" ")) {
            if (!"offline_access".equals(scope)) continue;
            return true;
        }
        return false;
    }

    public static RefreshToken getRefreshToken(byte[] decodedToken) throws JWSInputException {
        try {
            return JsonSerialization.readValue(decodedToken, RefreshToken.class);
        }
        catch (IOException e) {
            throw new JWSInputException(e);
        }
    }

    public static RefreshToken getRefreshToken(String refreshToken) throws JWSInputException {
        byte[] encodedContent = new JWSInput(refreshToken).getContent();
        return TokenUtil.getRefreshToken(encodedContent);
    }

    public static boolean isOfflineToken(String refreshToken) throws JWSInputException {
        RefreshToken token = TokenUtil.getRefreshToken(refreshToken);
        return token.getType().equals(TOKEN_TYPE_OFFLINE);
    }
}

