/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderSession;

public class ProviderFactoryLoader<T extends Provider>
implements Iterable<ProviderFactory<T>> {
    private final Map<String, ProviderFactory<T>> factories = new HashMap<String, ProviderFactory<T>>();

    /*
     * WARNING - void declaration
     */
    private ProviderFactoryLoader(ServiceLoader<? extends ProviderFactory> serviceLoader) {
        for (ProviderFactory providerFactory : serviceLoader) {
            void var3_3;
            if (System.getProperties().containsKey(providerFactory.getClass().getName() + ".disabled")) continue;
            if (providerFactory.lazyLoad()) {
                LazyProviderFactory lazyProviderFactory = new LazyProviderFactory(providerFactory);
            }
            this.factories.put(var3_3.getId(), (ProviderFactory<T>)var3_3);
        }
    }

    public static ProviderFactoryLoader create(Class<? extends ProviderFactory> service) {
        return new ProviderFactoryLoader(ServiceLoader.load(service));
    }

    public static ProviderFactoryLoader create(Class<? extends ProviderFactory> service, ClassLoader loader) {
        return new ProviderFactoryLoader(ServiceLoader.load(service, loader));
    }

    public ProviderFactory find(String id) {
        return this.factories.get(id);
    }

    @Override
    public Iterator<ProviderFactory<T>> iterator() {
        return this.factories.values().iterator();
    }

    public Set<String> providerIds() {
        return this.factories.keySet();
    }

    public void init() {
        for (ProviderFactory<T> p : this.factories.values()) {
            p.init();
        }
    }

    public void close() {
        for (ProviderFactory<T> p : this.factories.values()) {
            p.close();
        }
    }

    private class LazyProviderFactory<T extends Provider>
    implements ProviderFactory<T> {
        private final ProviderFactory<T> factory;
        private volatile boolean initialized = false;

        private LazyProviderFactory(ProviderFactory<T> factory) {
            this.factory = factory;
        }

        @Override
        public synchronized T create(ProviderSession providerSession) {
            if (!this.initialized) {
                this.factory.init();
                this.initialized = true;
            }
            return this.factory.create(providerSession);
        }

        @Override
        public void init() {
        }

        @Override
        public synchronized void close() {
            if (this.initialized) {
                this.factory.close();
            }
        }

        @Override
        public String getId() {
            return this.factory.getId();
        }

        @Override
        public boolean lazyLoad() {
            return false;
        }
    }
}

