/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.nio.file.Path;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;

public class VaultOptions {
    public static final Option<VaultType> VAULT = new OptionBuilder<VaultType>("vault", VaultType.class).category(OptionCategory.VAULT).description("Enables a vault provider.").buildTime(true).build();
    public static final Option<Path> VAULT_DIR = new OptionBuilder<Path>("vault-dir", Path.class).category(OptionCategory.VAULT).description("If set, secrets can be obtained by reading the content of files within the given directory.").build();
    public static final Option<String> VAULT_PASS = new OptionBuilder<String>("vault-pass", String.class).category(OptionCategory.VAULT).description("Password for the vault keystore.").build();
    public static final Option<Path> VAULT_FILE = new OptionBuilder<Path>("vault-file", Path.class).category(OptionCategory.VAULT).description("Path to the keystore file.").build();
    public static final Option<String> VAULT_TYPE = new OptionBuilder<String>("vault-type", String.class).category(OptionCategory.VAULT).description("Specifies the type of the keystore file.").defaultValue("PKCS12").build();

    public static enum VaultType {
        file("file"),
        keystore("keystore");

        private final String provider;

        private VaultType(String provider) {
            this.provider = provider;
        }

        public String getProvider() {
            return this.provider;
        }
    }
}

