/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.edit.actions;

import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.edit.actions.EditAction;

public class NextWordAction
extends EditAction {
    private final Mode mode;
    private boolean removeTrailingSpaces = true;

    public NextWordAction(int start, Action action, Mode mode) {
        super(start, action);
        this.mode = mode;
        if (this.getAction() == Action.CHANGE) {
            this.removeTrailingSpaces = false;
        }
    }

    @Override
    public void doAction(String buffer) {
        int cursor;
        if (this.mode == Mode.EMACS) {
            for (cursor = this.getStart(); cursor < buffer.length() && this.isDelimiter(buffer.charAt(cursor)); ++cursor) {
            }
            while (cursor < buffer.length() && !this.isDelimiter(buffer.charAt(cursor))) {
                ++cursor;
            }
        } else if (cursor < buffer.length() && this.isDelimiter(buffer.charAt(cursor))) {
            while (cursor < buffer.length() && this.isDelimiter(buffer.charAt(cursor))) {
                ++cursor;
            }
        } else {
            while (cursor < buffer.length() && !this.isDelimiter(buffer.charAt(cursor))) {
                ++cursor;
            }
            if (this.removeTrailingSpaces && cursor < buffer.length() && this.isSpace(buffer.charAt(cursor))) {
                while (cursor < buffer.length() && this.isSpace(buffer.charAt(cursor))) {
                    ++cursor;
                }
            }
        }
        if (this.removeTrailingSpaces && cursor < buffer.length() && this.isSpace(buffer.charAt(cursor))) {
            while (cursor < buffer.length() && this.isSpace(buffer.charAt(cursor))) {
                ++cursor;
            }
        }
        this.setEnd(cursor);
    }
}

