/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.jose.jwk.ECPublicJWK;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKUtil;
import org.keycloak.jose.jwk.RSAPublicJWK;

public abstract class AbstractJWKBuilder {
    public static final KeyUse DEFAULT_PUBLIC_KEY_USE = KeyUse.SIG;
    protected String kid;
    protected String algorithm;

    public JWK rs256(PublicKey key) {
        this.algorithm = "RS256";
        return this.rsa(key);
    }

    public JWK rsa(Key key) {
        return this.rsa(key, null, KeyUse.SIG);
    }

    public JWK rsa(Key key, X509Certificate certificate) {
        return this.rsa(key, Collections.singletonList(certificate), KeyUse.SIG);
    }

    public JWK rsa(Key key, List<X509Certificate> certificates) {
        return this.rsa(key, certificates, null);
    }

    public JWK rsa(Key key, List<X509Certificate> certificates, KeyUse keyUse) {
        RSAPublicKey rsaKey = (RSAPublicKey)key;
        RSAPublicJWK k = new RSAPublicJWK();
        String kid = this.kid != null ? this.kid : KeyUtils.createKeyId(key);
        k.setKeyId(kid);
        k.setKeyType("RSA");
        k.setAlgorithm(this.algorithm);
        k.setPublicKeyUse(keyUse == null ? KeyUse.SIG.getSpecName() : keyUse.getSpecName());
        k.setModulus(Base64Url.encode(JWKUtil.toIntegerBytes(rsaKey.getModulus())));
        k.setPublicExponent(Base64Url.encode(JWKUtil.toIntegerBytes(rsaKey.getPublicExponent())));
        if (certificates != null && !certificates.isEmpty()) {
            String[] certificateChain = new String[certificates.size()];
            for (int i = 0; i < certificates.size(); ++i) {
                certificateChain[i] = PemUtils.encodeCertificate(certificates.get(i));
            }
            k.setX509CertificateChain(certificateChain);
        }
        return k;
    }

    public JWK rsa(Key key, KeyUse keyUse) {
        String keyUseString;
        JWK k = this.rsa(key);
        String string = keyUseString = keyUse == null ? DEFAULT_PUBLIC_KEY_USE.getSpecName() : keyUse.getSpecName();
        if (KeyUse.ENC == keyUse) {
            keyUseString = "enc";
        }
        k.setPublicKeyUse(keyUseString);
        return k;
    }

    public JWK ec(Key key) {
        return this.ec(key, DEFAULT_PUBLIC_KEY_USE);
    }

    public JWK ec(Key key, KeyUse keyUse) {
        ECPublicKey ecKey = (ECPublicKey)key;
        ECPublicJWK k = new ECPublicJWK();
        String kid = this.kid != null ? this.kid : KeyUtils.createKeyId(key);
        int fieldSize = ecKey.getParams().getCurve().getField().getFieldSize();
        k.setKeyId(kid);
        k.setKeyType("EC");
        k.setAlgorithm(this.algorithm);
        k.setPublicKeyUse(keyUse == null ? DEFAULT_PUBLIC_KEY_USE.getSpecName() : keyUse.getSpecName());
        k.setCrv("P-" + fieldSize);
        k.setX(Base64Url.encode(JWKUtil.toIntegerBytes(ecKey.getW().getAffineX(), fieldSize)));
        k.setY(Base64Url.encode(JWKUtil.toIntegerBytes(ecKey.getW().getAffineY(), fieldSize)));
        return k;
    }

    public abstract JWK okp(Key var1);

    public abstract JWK okp(Key var1, KeyUse var2);

    public static byte[] reverseBytes(byte[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        int length = array.length;
        byte[] reversedArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            reversedArray[length - 1 - i] = array[i];
        }
        return reversedArray;
    }
}

