/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.models.utils.UserModelDelegate;

public class UpdateOnlyChangeUserModelDelegate
extends UserModelDelegate {
    public UpdateOnlyChangeUserModelDelegate(UserModel delegate) {
        super(delegate);
    }

    @Override
    public void setUsername(String username) {
        if (!ObjectUtil.isEqualOrBothNull(this.getUsername(), username)) {
            this.delegate.setUsername(username);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!ObjectUtil.isEqualOrBothNull(this.isEnabled(), enabled)) {
            this.delegate.setEnabled(enabled);
        }
    }

    @Override
    public void setSingleAttribute(String name, String value) {
        if (!ObjectUtil.isEqualOrBothNull(this.getFirstAttribute(name), value)) {
            this.delegate.setSingleAttribute(name, value);
        }
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        if (!ObjectUtil.isEqualOrBothNull(this.getAttributeStream(name).collect(Collectors.toList()), values)) {
            this.delegate.setAttribute(name, values);
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (this.getAttributeStream(name).count() > 0L) {
            this.delegate.removeAttribute(name);
        }
    }

    @Override
    public void addRequiredAction(String action) {
        if (action != null) {
            if (this.getRequiredActionsStream().noneMatch(action::equals)) {
                this.delegate.addRequiredAction(action);
            }
        }
    }

    @Override
    public void removeRequiredAction(String action) {
        if (action != null) {
            if (this.getRequiredActionsStream().anyMatch(action::equals)) {
                this.delegate.removeRequiredAction(action);
            }
        }
    }

    @Override
    public void addRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.addRequiredAction(actionName);
    }

    @Override
    public void removeRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.removeRequiredAction(actionName);
    }

    @Override
    public void setFirstName(String firstName) {
        if (!ObjectUtil.isEqualOrBothNull(this.getFirstName(), firstName)) {
            this.delegate.setFirstName(firstName);
        }
    }

    @Override
    public void setLastName(String lastName) {
        if (!ObjectUtil.isEqualOrBothNull(this.getLastName(), lastName)) {
            this.delegate.setLastName(lastName);
        }
    }

    @Override
    public void setEmail(String email) {
        if (!ObjectUtil.isEqualOrBothNull(this.getEmail(), email)) {
            this.delegate.setEmail(email);
        }
    }

    @Override
    public void setEmailVerified(boolean verified) {
        if (!ObjectUtil.isEqualOrBothNull(this.isEmailVerified(), verified)) {
            this.delegate.setEmailVerified(verified);
        }
    }

    @Override
    public void grantRole(RoleModel role) {
        if (!this.hasDirectRole(role)) {
            this.delegate.grantRole(role);
        }
    }

    @Override
    public void deleteRoleMapping(RoleModel role) {
        if (this.hasDirectRole(role)) {
            this.delegate.deleteRoleMapping(role);
        }
    }

    @Override
    public void setFederationLink(String link) {
        if (!ObjectUtil.isEqualOrBothNull(this.getFederationLink(), link)) {
            this.delegate.setFederationLink(link);
        }
    }

    @Override
    public void setServiceAccountClientLink(String clientInternalId) {
        if (!ObjectUtil.isEqualOrBothNull(this.getServiceAccountClientLink(), clientInternalId)) {
            this.delegate.setServiceAccountClientLink(clientInternalId);
        }
    }

    @Override
    public void setCreatedTimestamp(Long timestamp) {
        if (!ObjectUtil.isEqualOrBothNull(this.getCreatedTimestamp(), timestamp)) {
            this.delegate.setCreatedTimestamp(timestamp);
        }
    }

    @Override
    public void joinGroup(GroupModel group) {
        if (!RoleUtils.isDirectMember(this.getGroupsStream(), group)) {
            this.delegate.joinGroup(group);
        }
    }

    @Override
    public void leaveGroup(GroupModel group) {
        if (RoleUtils.isDirectMember(this.getGroupsStream(), group)) {
            this.delegate.leaveGroup(group);
        }
    }
}

