/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.component;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;

public interface AmphibianProviderFactory<ProviderType extends Provider>
extends ProviderFactory<ProviderType>,
ComponentFactory<ProviderType, ProviderType> {
    @Override
    public ProviderType create(KeycloakSession var1);

    @Override
    @Deprecated
    default public ProviderType create(KeycloakSession session, ComponentModel model) {
        throw new UnsupportedOperationException("Use create(KeycloakSession) instead");
    }

    @Override
    default public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    @Override
    default public void onUpdate(KeycloakSession session, RealmModel realm, ComponentModel oldModel, ComponentModel newModel) {
        String newId;
        String oldId = oldModel == null ? null : oldModel.getId();
        String string = newId = newModel == null ? null : newModel.getId();
        if (oldId != null) {
            if (newId == null || Objects.equals(oldId, newId)) {
                session.invalidate(InvalidationHandler.ObjectType.COMPONENT, oldId);
            } else {
                session.invalidate(InvalidationHandler.ObjectType.COMPONENT, oldId, newId);
            }
        } else if (newId != null) {
            session.invalidate(InvalidationHandler.ObjectType.COMPONENT, newId);
        }
    }

    @Override
    default public void preRemove(KeycloakSession session, RealmModel realm, ComponentModel model) {
        if (model != null && model.getId() != null) {
            session.invalidate(InvalidationHandler.ObjectType.COMPONENT, model.getId());
        }
    }

    @Override
    default public void close() {
    }
}

