/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization;

import java.util.EnumMap;
import java.util.List;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;

public class UserManagedPermissionUtil {
    public static void updatePolicy(PermissionTicket ticket, StoreFactory storeFactory) {
        Scope scope = ticket.getScope();
        Policy policy = ticket.getPolicy();
        ResourceServer resourceServer = ticket.getResourceServer();
        if (policy == null) {
            EnumMap<PermissionTicket.FilterOption, String> filter = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
            filter.put(PermissionTicket.FilterOption.OWNER, ticket.getOwner());
            filter.put(PermissionTicket.FilterOption.REQUESTER, ticket.getRequester());
            filter.put(PermissionTicket.FilterOption.RESOURCE_ID, ticket.getResource().getId());
            filter.put(PermissionTicket.FilterOption.POLICY_IS_NOT_NULL, Boolean.TRUE.toString());
            List<PermissionTicket> tickets = storeFactory.getPermissionTicketStore().find(resourceServer.getRealm(), resourceServer, filter, null, null);
            if (!tickets.isEmpty()) {
                policy = tickets.iterator().next().getPolicy();
            }
        }
        if (ticket.isGranted()) {
            if (policy == null) {
                policy = UserManagedPermissionUtil.createUserManagedPermission(ticket, storeFactory);
            }
            if (scope != null && !policy.getScopes().contains(scope)) {
                policy.addScope(scope);
            }
            ticket.setPolicy(policy);
        } else if (scope != null) {
            policy.removeScope(scope);
            ticket.setPolicy(null);
        }
    }

    public static void removePolicy(PermissionTicket ticket, StoreFactory storeFactory) {
        Policy policy = ticket.getPolicy();
        RealmModel realm = ticket.getResourceServer().getRealm();
        if (policy != null) {
            EnumMap<PermissionTicket.FilterOption, String> filter = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
            filter.put(PermissionTicket.FilterOption.OWNER, ticket.getOwner());
            filter.put(PermissionTicket.FilterOption.REQUESTER, ticket.getRequester());
            filter.put(PermissionTicket.FilterOption.RESOURCE_ID, ticket.getResource().getId());
            filter.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
            List<PermissionTicket> tickets = storeFactory.getPermissionTicketStore().find(realm, ticket.getResourceServer(), filter, null, null);
            if (tickets.isEmpty()) {
                PolicyStore policyStore = storeFactory.getPolicyStore();
                for (Policy associatedPolicy : policy.getAssociatedPolicies()) {
                    policyStore.delete(realm, associatedPolicy.getId());
                }
                policyStore.delete(realm, policy.getId());
            } else if (ticket.getScope() != null) {
                policy.removeScope(ticket.getScope());
            }
        }
    }

    private static Policy createUserManagedPermission(PermissionTicket ticket, StoreFactory storeFactory) {
        PolicyStore policyStore = storeFactory.getPolicyStore();
        UserPolicyRepresentation userPolicyRep = new UserPolicyRepresentation();
        userPolicyRep.setName(KeycloakModelUtils.generateId());
        userPolicyRep.addUser(ticket.getRequester());
        Policy userPolicy = policyStore.create(ticket.getResourceServer(), userPolicyRep);
        userPolicy.setOwner(ticket.getOwner());
        PolicyRepresentation policyRep = new PolicyRepresentation();
        policyRep.setName(KeycloakModelUtils.generateId());
        policyRep.setType("uma");
        policyRep.addPolicy(userPolicy.getId());
        Policy policy = policyStore.create(ticket.getResourceServer(), policyRep);
        policy.setOwner(ticket.getOwner());
        policy.addResource(ticket.getResource());
        Scope scope = ticket.getScope();
        if (scope != null) {
            policy.addScope(scope);
        }
        return policy;
    }
}

