/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.policy.MaximumLengthPasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProviderFactory;

public class MaximumLengthPasswordPolicyProviderFactory
implements PasswordPolicyProviderFactory {
    public static final String ID = "maxLength";
    public static final int DEFAULT_MAX_LENGTH = 64;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public PasswordPolicyProvider create(KeycloakSession session) {
        return new MaximumLengthPasswordPolicyProvider(session.getContext());
    }

    @Override
    public void init(Config.Scope config) {
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
    }

    @Override
    public String getDisplayName() {
        return "Maximum Length";
    }

    @Override
    public String getConfigType() {
        return "int";
    }

    @Override
    public String getDefaultConfigValue() {
        return Integer.toString(64);
    }

    @Override
    public boolean isMultiplSupported() {
        return false;
    }

    @Override
    public void close() {
    }
}

