/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.List;
import java.util.function.Function;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ReadOnlyException;

public class ReadOnlyUserModelDelegate
extends UserModelDelegate {
    private final Function<String, RuntimeException> exceptionCreator;

    public ReadOnlyUserModelDelegate(UserModel delegate) {
        this(delegate, ReadOnlyException::new);
    }

    public ReadOnlyUserModelDelegate(UserModel delegate, Function<String, RuntimeException> exceptionCreator) {
        super(delegate);
        this.exceptionCreator = exceptionCreator;
    }

    @Override
    public void setUsername(String username) {
        throw this.readOnlyException("username");
    }

    @Override
    public void setEnabled(boolean enabled) {
        throw this.readOnlyException("enabled");
    }

    @Override
    public void setSingleAttribute(String name, String value) {
        throw this.readOnlyException("attribute(" + name + ")");
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        throw this.readOnlyException("attribute(" + name + ")");
    }

    @Override
    public void removeAttribute(String name) {
        throw this.readOnlyException("attribute(" + name + ")");
    }

    @Override
    public void addRequiredAction(String action) {
        throw this.readOnlyException("required action " + action);
    }

    @Override
    public void removeRequiredAction(String action) {
        throw this.readOnlyException("required action " + action);
    }

    @Override
    public void addRequiredAction(UserModel.RequiredAction action) {
        throw this.readOnlyException("required action " + (Object)((Object)action));
    }

    @Override
    public void removeRequiredAction(UserModel.RequiredAction action) {
        throw this.readOnlyException("required action " + (Object)((Object)action));
    }

    @Override
    public void setFirstName(String firstName) {
        throw this.readOnlyException("firstName");
    }

    @Override
    public void setLastName(String lastName) {
        throw this.readOnlyException("lastName");
    }

    @Override
    public void setEmail(String email) {
        throw this.readOnlyException("email");
    }

    @Override
    public void setEmailVerified(boolean verified) {
        throw this.readOnlyException("emailVerified");
    }

    @Override
    public void deleteRoleMapping(RoleModel role) {
        throw this.readOnlyException("role mapping for role " + role.getName());
    }

    @Override
    public void setFederationLink(String link) {
        throw this.readOnlyException("federationLink");
    }

    @Override
    public void setServiceAccountClientLink(String clientInternalId) {
        throw this.readOnlyException("serviceAccountClientLink");
    }

    @Override
    public void setCreatedTimestamp(Long timestamp) {
        throw this.readOnlyException("createdTimestamp");
    }

    @Override
    public void joinGroup(GroupModel group) {
        throw this.readOnlyException("group mapping for group " + group.getName());
    }

    @Override
    public void leaveGroup(GroupModel group) {
        throw this.readOnlyException("group mapping for group " + group.getName());
    }

    @Override
    public void grantRole(RoleModel role) {
        throw this.readOnlyException("role mapping for role " + role.getName());
    }

    private RuntimeException readOnlyException(String detail) {
        String message = String.format("Not possible to write '%s' when updating user '%s'", detail, this.getUsername());
        return this.exceptionCreator.apply(message);
    }
}

