/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.AbstractKeycloakTransaction;

public class EventListenerTransaction
extends AbstractKeycloakTransaction {
    private final List<AdminEventEntry> adminEventsToSend = new LinkedList<AdminEventEntry>();
    private final List<Event> eventsToSend = new LinkedList<Event>();
    private final BiConsumer<AdminEvent, Boolean> adminEventConsumer;
    private final Consumer<Event> eventConsumer;

    public EventListenerTransaction(BiConsumer<AdminEvent, Boolean> adminEventConsumer, Consumer<Event> eventConsumer) {
        this.adminEventConsumer = adminEventConsumer;
        this.eventConsumer = eventConsumer;
    }

    public void addAdminEvent(AdminEvent adminEvent, boolean includeRepresentation) {
        this.adminEventsToSend.add(new AdminEventEntry(adminEvent, includeRepresentation));
    }

    public void addEvent(Event event) {
        this.eventsToSend.add(event);
    }

    @Override
    protected void commitImpl() {
        this.adminEventsToSend.forEach(this::consumeAdminEventEntry);
        if (this.eventConsumer != null) {
            this.eventsToSend.forEach(this.eventConsumer);
        }
    }

    private void consumeAdminEventEntry(AdminEventEntry entry) {
        if (this.adminEventConsumer != null) {
            this.adminEventConsumer.accept(entry.event, entry.includeRepresentation);
        }
    }

    @Override
    protected void rollbackImpl() {
        this.adminEventsToSend.clear();
        this.eventsToSend.clear();
    }

    private static class AdminEventEntry {
        private final AdminEvent event;
        private final boolean includeRepresentation;

        public AdminEventEntry(AdminEvent event, boolean includeRepresentation) {
            this.event = event;
            this.includeRepresentation = includeRepresentation;
        }
    }
}

