/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.ClientRepresentationMixIn;
import org.keycloak.client.registration.HttpUtil;
import org.keycloak.client.registration.OIDCClientRepresentationMixIn;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.util.JsonSerialization;

public class ClientRegistration {
    public static final ObjectMapper outputMapper = new ObjectMapper();
    private final String JSON = "application/json";
    private final String XML = "application/xml";
    private final String DEFAULT = "default";
    private final String INSTALLATION = "install";
    private final String OIDC = "openid-connect";
    private final String SAML = "saml2-entity-descriptor";
    private HttpUtil httpUtil;

    public static ClientRegistrationBuilder create() {
        return new ClientRegistrationBuilder();
    }

    ClientRegistration(HttpUtil httpUtil) {
        this.httpUtil = httpUtil;
    }

    public void close() throws ClientRegistrationException {
        if (this.httpUtil != null) {
            this.httpUtil.close();
        }
        this.httpUtil = null;
    }

    public ClientRegistration auth(Auth auth) {
        this.httpUtil.setAuth(auth);
        return this;
    }

    public ClientRepresentation create(ClientRepresentation client) throws ClientRegistrationException {
        String content = ClientRegistration.serialize(client);
        InputStream resultStream = this.httpUtil.doPost(content, "application/json", StandardCharsets.UTF_8, "application/json", "default");
        return ClientRegistration.deserialize(resultStream, ClientRepresentation.class);
    }

    public ClientRepresentation get(String clientId) throws ClientRegistrationException {
        InputStream resultStream = this.httpUtil.doGet("application/json", "default", clientId);
        return resultStream != null ? ClientRegistration.deserialize(resultStream, ClientRepresentation.class) : null;
    }

    public AdapterConfig getAdapterConfig(String clientId) throws ClientRegistrationException {
        InputStream resultStream = this.httpUtil.doGet("application/json", "install", clientId);
        return resultStream != null ? ClientRegistration.deserialize(resultStream, AdapterConfig.class) : null;
    }

    public ClientRepresentation update(ClientRepresentation client) throws ClientRegistrationException {
        String content = ClientRegistration.serialize(client);
        InputStream resultStream = this.httpUtil.doPut(content, "application/json", StandardCharsets.UTF_8, "application/json", "default", client.getClientId());
        return resultStream != null ? ClientRegistration.deserialize(resultStream, ClientRepresentation.class) : null;
    }

    public void delete(ClientRepresentation client) throws ClientRegistrationException {
        this.delete(client.getClientId());
    }

    public void delete(String clientId) throws ClientRegistrationException {
        this.httpUtil.doDelete("default", clientId);
    }

    public OIDCClientRegistration oidc() {
        return new OIDCClientRegistration();
    }

    public SAMLClientRegistration saml() {
        return new SAMLClientRegistration();
    }

    public static String serialize(Object obj) throws ClientRegistrationException {
        try {
            return outputMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to write json object", e);
        }
    }

    private static <T> T deserialize(InputStream inputStream, Class<T> clazz) throws ClientRegistrationException {
        try {
            return (T)JsonSerialization.readValue((InputStream)inputStream, clazz);
        }
        catch (IOException e) {
            throw new ClientRegistrationException("Failed to read json object", e);
        }
    }

    static {
        outputMapper.addMixIn(ClientRepresentation.class, ClientRepresentationMixIn.class);
        outputMapper.addMixIn(OIDCClientRepresentation.class, OIDCClientRepresentationMixIn.class);
        outputMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class ClientRegistrationBuilder {
        private String url;
        private HttpClient httpClient;

        ClientRegistrationBuilder() {
        }

        public ClientRegistrationBuilder url(String realmUrl) {
            this.url = realmUrl;
            return this;
        }

        public ClientRegistrationBuilder url(String authUrl, String realm) {
            this.url = HttpUtil.getUrl(authUrl, "realms", realm, "clients-registrations");
            return this;
        }

        public ClientRegistrationBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public ClientRegistration build() {
            if (this.url == null) {
                throw new IllegalStateException("url not configured");
            }
            if (this.httpClient == null) {
                this.httpClient = HttpClients.createDefault();
            }
            return new ClientRegistration(new HttpUtil(this.httpClient, this.url));
        }
    }

    public class OIDCClientRegistration {
        public OIDCClientRepresentation create(OIDCClientRepresentation client) throws ClientRegistrationException {
            String content = ClientRegistration.serialize(client);
            InputStream resultStream = ClientRegistration.this.httpUtil.doPost(content, "application/json", StandardCharsets.UTF_8, "application/json", "openid-connect");
            return ClientRegistration.deserialize(resultStream, OIDCClientRepresentation.class);
        }

        public OIDCClientRepresentation get(String clientId) throws ClientRegistrationException {
            InputStream resultStream = ClientRegistration.this.httpUtil.doGet("application/json", "openid-connect", clientId);
            return resultStream != null ? ClientRegistration.deserialize(resultStream, OIDCClientRepresentation.class) : null;
        }

        public OIDCClientRepresentation update(OIDCClientRepresentation client) throws ClientRegistrationException {
            String content = ClientRegistration.serialize(client);
            InputStream resultStream = ClientRegistration.this.httpUtil.doPut(content, "application/json", StandardCharsets.UTF_8, "application/json", "openid-connect", client.getClientId());
            return resultStream != null ? ClientRegistration.deserialize(resultStream, OIDCClientRepresentation.class) : null;
        }

        public void delete(OIDCClientRepresentation client) throws ClientRegistrationException {
            this.delete(client.getClientId());
        }

        public void delete(String clientId) throws ClientRegistrationException {
            ClientRegistration.this.httpUtil.doDelete("openid-connect", clientId);
        }
    }

    public class SAMLClientRegistration {
        public ClientRepresentation create(String entityDescriptor) throws ClientRegistrationException {
            InputStream resultStream = ClientRegistration.this.httpUtil.doPost(entityDescriptor, "application/xml", StandardCharsets.UTF_8, "application/json", "saml2-entity-descriptor");
            return ClientRegistration.deserialize(resultStream, ClientRepresentation.class);
        }
    }
}

