/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.HashSet;
import org.jboss.logging.Logger;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.AbstractPolicyEnforcer;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.resource.PermissionResource;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.PermissionRequest;

public class BearerTokenPolicyEnforcer
extends AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(BearerTokenPolicyEnforcer.class);

    public BearerTokenPolicyEnforcer(PolicyEnforcer enforcer) {
        super(enforcer);
    }

    @Override
    protected boolean challenge(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, OIDCHttpFacade facade) {
        HttpFacade.Response response = facade.getResponse();
        AuthzClient authzClient = this.getAuthzClient();
        String ticket = this.getPermissionTicket(pathConfig, methodConfig, authzClient);
        if (ticket == null) {
            response.setStatus(403);
            return true;
        }
        String realm = authzClient.getConfiguration().getRealm();
        String authorizationServerUri = authzClient.getServerConfiguration().getIssuer().toString();
        response.setStatus(401);
        StringBuilder wwwAuthenticate = new StringBuilder("UMA realm=\"").append(realm).append("\"").append(",as_uri=\"").append(authorizationServerUri).append("\"");
        if (ticket != null) {
            wwwAuthenticate.append(",ticket=\"").append(ticket).append("\"");
        }
        response.setHeader("WWW-Authenticate", wwwAuthenticate.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending UMA challenge");
        }
        return true;
    }

    private String getPermissionTicket(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, AuthzClient authzClient) {
        if (this.getEnforcerConfig().getUserManagedAccess() != null) {
            ProtectionResource protection = authzClient.protection();
            PermissionResource permission = protection.permission();
            PermissionRequest permissionRequest = new PermissionRequest();
            permissionRequest.setResourceId(pathConfig.getId());
            permissionRequest.setScopes(new HashSet<String>(methodConfig.getScopes()));
            return permission.create(permissionRequest).getTicket();
        }
        return null;
    }
}

