/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwe;

import java.io.IOException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.JWERegistry;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import org.keycloak.util.JsonSerialization;

public class JWE {
    private JWEHeader header;
    private String base64Header;
    private JWEKeyStorage keyStorage = new JWEKeyStorage();
    private String base64Cek;
    private byte[] initializationVector;
    private byte[] content;
    private byte[] encryptedContent;
    private byte[] authenticationTag;

    public JWE header(JWEHeader header) {
        this.header = header;
        this.base64Header = null;
        return this;
    }

    JWEHeader getHeader() {
        if (this.header == null && this.base64Header != null) {
            try {
                byte[] decodedHeader = Base64Url.decode(this.base64Header);
                this.header = JsonSerialization.readValue(decodedHeader, JWEHeader.class);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.header;
    }

    public String getBase64Header() throws IOException {
        if (this.base64Header == null && this.header != null) {
            byte[] contentBytes = JsonSerialization.writeValueAsBytes(this.header);
            this.base64Header = Base64Url.encode(contentBytes);
        }
        return this.base64Header;
    }

    public JWEKeyStorage getKeyStorage() {
        return this.keyStorage;
    }

    public byte[] getInitializationVector() {
        return this.initializationVector;
    }

    public JWE content(byte[] content) {
        this.content = content;
        return this;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getEncryptedContent() {
        return this.encryptedContent;
    }

    public byte[] getAuthenticationTag() {
        return this.authenticationTag;
    }

    public void setEncryptedContentInfo(byte[] initializationVector, byte[] encryptedContent, byte[] authenticationTag) {
        this.initializationVector = initializationVector;
        this.encryptedContent = encryptedContent;
        this.authenticationTag = authenticationTag;
    }

    public String encodeJwe() throws JWEException {
        try {
            if (this.header == null) {
                throw new IllegalStateException("Header must be set");
            }
            if (this.content == null) {
                throw new IllegalStateException("Content must be set");
            }
            JWEAlgorithmProvider algorithmProvider = JWERegistry.getAlgProvider(this.header.getAlgorithm());
            if (algorithmProvider == null) {
                throw new IllegalArgumentException("No provider for alg '" + this.header.getAlgorithm() + "'");
            }
            JWEEncryptionProvider encryptionProvider = JWERegistry.getEncProvider(this.header.getEncryptionAlgorithm());
            if (encryptionProvider == null) {
                throw new IllegalArgumentException("No provider for enc '" + this.header.getAlgorithm() + "'");
            }
            this.keyStorage.setEncryptionProvider(encryptionProvider);
            this.keyStorage.getCEKKey(JWEKeyStorage.KeyUse.ENCRYPTION, true);
            byte[] encodedCEK = algorithmProvider.encodeCek(encryptionProvider, this.keyStorage, this.keyStorage.getEncryptionKey());
            this.base64Cek = Base64Url.encode(encodedCEK);
            encryptionProvider.encodeJwe(this);
            return this.getEncodedJweString();
        }
        catch (Exception e) {
            throw new JWEException(e);
        }
    }

    private String getEncodedJweString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.base64Header).append(".").append(this.base64Cek).append(".").append(Base64Url.encode(this.initializationVector)).append(".").append(Base64Url.encode(this.encryptedContent)).append(".").append(Base64Url.encode(this.authenticationTag));
        return builder.toString();
    }

    public JWE verifyAndDecodeJwe(String jweStr) throws JWEException {
        try {
            String[] parts = jweStr.split("\\.");
            if (parts.length != 5) {
                throw new IllegalStateException("Not a JWE String");
            }
            this.base64Header = parts[0];
            this.base64Cek = parts[1];
            this.initializationVector = Base64Url.decode(parts[2]);
            this.encryptedContent = Base64Url.decode(parts[3]);
            this.authenticationTag = Base64Url.decode(parts[4]);
            this.header = this.getHeader();
            JWEAlgorithmProvider algorithmProvider = JWERegistry.getAlgProvider(this.header.getAlgorithm());
            if (algorithmProvider == null) {
                throw new IllegalArgumentException("No provider for alg '" + this.header.getAlgorithm() + "'");
            }
            JWEEncryptionProvider encryptionProvider = JWERegistry.getEncProvider(this.header.getEncryptionAlgorithm());
            if (encryptionProvider == null) {
                throw new IllegalArgumentException("No provider for enc '" + this.header.getAlgorithm() + "'");
            }
            this.keyStorage.setEncryptionProvider(encryptionProvider);
            byte[] decodedCek = algorithmProvider.decodeCek(Base64Url.decode(this.base64Cek), this.keyStorage.getEncryptionKey());
            this.keyStorage.setCEKBytes(decodedCek);
            encryptionProvider.verifyAndDecodeJwe(this);
            return this;
        }
        catch (Exception e) {
            throw new JWEException(e);
        }
    }

    static {
        BouncyIntegration.init();
    }
}

