/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.camel.undertow;

import io.undertow.server.HttpServerExchange;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.camel.undertow.UndertowKeycloakConsumer;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class UndertowKeycloakEndpoint
extends UndertowEndpoint {
    private static final Logger LOG = Logger.getLogger(UndertowKeycloakEndpoint.class.getName());
    private KeycloakConfigResolver configResolver;
    private AdapterConfig adapterConfig;
    private String skipPattern;
    private List<String> allowedRoles = Collections.emptyList();
    private int confidentialPort = 8443;

    public UndertowKeycloakEndpoint(String uri, UndertowComponent component) {
        super(uri, component);
    }

    public AdapterConfig getAdapterConfig() {
        return this.adapterConfig;
    }

    public void setAdapterConfig(AdapterConfig adapterConfig) {
        LOG.info("adapterConfig");
        this.adapterConfig = adapterConfig;
    }

    public String getSkipPattern() {
        return this.skipPattern;
    }

    public void setSkipPattern(String skipPattern) {
        this.skipPattern = skipPattern;
    }

    public List<String> getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setAllowedRoles(List<String> allowedRoles) {
        this.allowedRoles = allowedRoles;
    }

    public void setAllowedRoles(String allowedRoles) {
        this.allowedRoles = allowedRoles == null ? null : Arrays.asList(allowedRoles.split("\\s*,\\s*"));
    }

    public int getConfidentialPort() {
        return this.confidentialPort;
    }

    public void setConfidentialPort(int confidentialPort) {
        this.confidentialPort = confidentialPort;
    }

    public KeycloakConfigResolver getConfigResolver() {
        return this.configResolver;
    }

    public void setConfigResolver(KeycloakConfigResolver configResolver) {
        this.configResolver = configResolver;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new UndertowKeycloakConsumer(this, processor, this.getDeploymentContext(), this.getSkipPatternAsPattern(), this.computeAllowedRoles(), this.confidentialPort);
    }

    public List<String> computeAllowedRoles() {
        List<Object> res;
        List<Object> list = res = this.allowedRoles == null ? Collections.emptyList() : this.allowedRoles;
        if (res.isEmpty()) {
            LOG.warning("No roles were configured, Keycloak will deny every request");
        }
        LOG.log(Level.FINE, "Allowed roles: {0}", res);
        return res;
    }

    public Exchange createExchange(HttpServerExchange httpExchange) throws Exception {
        Exchange res = super.createExchange(httpExchange);
        KeycloakPrincipal principal = (KeycloakPrincipal)httpExchange.getAttachment(UndertowKeycloakConsumer.KEYCLOAK_PRINCIPAL_KEY);
        LOG.log(Level.FINE, "principal: {0}", principal);
        if (principal != null) {
            res.setProperty(KeycloakPrincipal.class.getName(), (Object)principal);
        }
        return res;
    }

    private AdapterDeploymentContext getDeploymentContext() {
        if (this.configResolver != null) {
            LOG.log(Level.INFO, "Using {0} to resolve Keycloak configuration on a per-request basis.", this.configResolver.getClass());
            return new AdapterDeploymentContext(this.configResolver);
        }
        if (this.adapterConfig != null) {
            KeycloakDeployment kd = KeycloakDeploymentBuilder.build((AdapterConfig)this.adapterConfig);
            return new AdapterDeploymentContext(kd);
        }
        LOG.warning("Adapter is unconfigured, Keycloak will deny every request");
        return new AdapterDeploymentContext();
    }

    private Pattern getSkipPatternAsPattern() {
        return this.skipPattern == null ? null : Pattern.compile(this.skipPattern, 32);
    }
}

