/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.representation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.keycloak.authorization.client.representation.ScopeRepresentation;

public class ResourceRepresentation {
    @JsonProperty(value="_id")
    private String id;
    private String name;
    private String displayName;
    private String uri;
    private String type;
    @JsonProperty(value="resource_scopes")
    private Set<ScopeRepresentation> scopes;
    @JsonProperty(value="icon_uri")
    private String iconUri;
    private String owner;
    private Boolean ownerManagedAccess;

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, String uri, String type, String iconUri) {
        this.name = name;
        this.scopes = scopes;
        this.uri = uri;
        this.type = type;
        this.iconUri = iconUri;
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, String uri, String type) {
        this(name, scopes, uri, type, null);
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes) {
        this(name, scopes, null, null, null);
    }

    public ResourceRepresentation() {
        this(null, null, null, null, null);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUri() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public Set<ScopeRepresentation> getScopes() {
        if (this.scopes == null) {
            this.scopes = Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.scopes);
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setScopes(Set<ScopeRepresentation> scopes) {
        this.scopes = scopes;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setOwnerManagedAccess(Boolean ownerManagedAccess) {
        this.ownerManagedAccess = ownerManagedAccess;
    }

    public Boolean getOwnerManagedAccess() {
        return this.ownerManagedAccess;
    }

    public void addScope(ScopeRepresentation scopeRepresentation) {
        if (this.scopes == null) {
            this.scopes = new HashSet<ScopeRepresentation>();
        }
        this.scopes.add(scopeRepresentation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRepresentation that = (ResourceRepresentation)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ResourceRepresentation{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", uri='" + this.uri + '\'' + ", type='" + this.type + '\'' + ", owner='" + this.owner + '\'' + ", scopes=" + this.scopes + '}';
    }
}

