/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

class ASN1Encoder {
    static final int INTEGER = 2;
    static final int SEQUENCE = 16;
    static final int CONSTRUCTED = 32;
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();

    private ASN1Encoder() {
    }

    public static ASN1Encoder create() {
        return new ASN1Encoder();
    }

    public ASN1Encoder write(BigInteger value) throws IOException {
        this.writeEncoded(2, value.toByteArray());
        return this;
    }

    public ASN1Encoder writeDerSeq(ASN1Encoder ... objects) throws IOException {
        this.writeEncoded(48, this.concatenate(objects));
        return this;
    }

    public byte[] toByteArray() {
        return this.os.toByteArray();
    }

    void writeEncoded(int tag, byte[] bytes) throws IOException {
        this.write(tag);
        this.writeLength(bytes.length);
        this.write(bytes);
    }

    void writeLength(int length) throws IOException {
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            this.write((byte)(size | 0x80));
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                this.write((byte)(length >> i));
            }
        } else {
            this.write((byte)length);
        }
    }

    void write(byte[] bytes) throws IOException {
        this.os.write(bytes);
    }

    void write(int b) throws IOException {
        this.os.write(b);
    }

    byte[] concatenate(ASN1Encoder ... objects) throws IOException {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        for (ASN1Encoder object : objects) {
            tmp.write(object.toByteArray());
        }
        return tmp.toByteArray();
    }
}

