/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.as7;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.keycloak.subsystem.as7.KeycloakAdapterConfigService;
import org.keycloak.subsystem.as7.RealmDefinition;
import org.keycloak.subsystem.as7.SharedAttributeDefinitons;

public final class RealmAddHandler
extends AbstractAddStepHandler {
    public static RealmAddHandler INSTANCE = new RealmAddHandler();

    private RealmAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : RealmDefinition.ALL_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        if (!SharedAttributeDefinitons.validateTruststoreSetIfRequired(model.clone())) {
            throw new OperationFailedException("truststore and truststore-password must be set if ssl-required is not none and disable-trust-manager is false.");
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        KeycloakAdapterConfigService ckService = KeycloakAdapterConfigService.getInstance();
        ckService.addRealm(operation, context.resolveExpressions(model));
    }
}

