/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.as7;

import java.util.ArrayList;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ValveMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.keycloak.adapters.jbossweb.KeycloakAuthenticatorValve;
import org.keycloak.subsystem.as7.KeycloakAdapterConfigService;
import org.keycloak.subsystem.as7.logging.KeycloakLogger;

public class KeycloakAdapterConfigDeploymentProcessor
implements DeploymentUnitProcessor {
    protected Logger log = Logger.getLogger(KeycloakAdapterConfigDeploymentProcessor.class);
    public static final String AUTH_DATA_PARAM_NAME = "org.keycloak.json.adapterConfig";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        KeycloakAdapterConfigService service = KeycloakAdapterConfigService.getInstance();
        LoginConfigMetaData loginConfig = webMetaData.getLoginConfig();
        if (!(service.isSecureDeployment(deploymentName) || loginConfig != null && loginConfig.getAuthMethod().equalsIgnoreCase("KEYCLOAK"))) {
            return;
        }
        this.log.debug((Object)("Setting up KEYCLOAK auth method for WAR: " + deploymentName));
        loginConfig.setAuthMethod("KEYCLOAK");
        if (service.isSecureDeployment(deploymentName)) {
            this.addJSONData(service.getJSON(deploymentName), warMetaData);
            loginConfig.setRealmName(service.getRealmName(deploymentName));
        }
        this.addValve(webMetaData);
        KeycloakLogger.ROOT_LOGGER.deploymentSecured(deploymentName);
    }

    private void addValve(JBossWebMetaData webMetaData) {
        ArrayList<ValveMetaData> valves = webMetaData.getValves();
        if (valves == null) {
            valves = new ArrayList<ValveMetaData>(1);
            webMetaData.setValves(valves);
        }
        ValveMetaData valve = new ValveMetaData();
        valve.setValveClass(KeycloakAuthenticatorValve.class.getName());
        valve.setModule("org.keycloak.keycloak-as7-adapter");
        valves.add(valve);
    }

    private void addJSONData(String json, WarMetaData warMetaData) {
        ArrayList<ParamValueMetaData> contextParams;
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((contextParams = webMetaData.getContextParams()) == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(AUTH_DATA_PARAM_NAME);
        param.setParamValue(json);
        contextParams.add(param);
        webMetaData.setContextParams(contextParams);
    }

    public void undeploy(DeploymentUnit du) {
    }
}

