/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import java.security.Principal;
import java.util.Set;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.CookieTokenStore;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.as7.CatalinaSecurityContextHelper;

public class CatalinaCookieTokenStore
implements AdapterTokenStore {
    private static final Logger log = Logger.getLogger(CatalinaCookieTokenStore.class);
    private Request request;
    private HttpFacade facade;
    private KeycloakDeployment deployment;
    private KeycloakPrincipal<RefreshableKeycloakSecurityContext> authenticatedPrincipal;

    public CatalinaCookieTokenStore(Request request, HttpFacade facade, KeycloakDeployment deployment) {
        this.request = request;
        this.facade = facade;
        this.deployment = deployment;
    }

    public void checkCurrentToken() {
        this.authenticatedPrincipal = this.checkPrincipalFromCookie();
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        if (this.authenticatedPrincipal != null) {
            log.debug((Object)"remote logged in already. Establish state from cookie");
            RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)this.authenticatedPrincipal.getKeycloakSecurityContext();
            if (!securityContext.getRealm().equals(this.deployment.getRealm())) {
                log.debug((Object)"Account from cookie is from a different realm than for the request.");
                return false;
            }
            securityContext.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
            Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
            GenericPrincipal principal = new CatalinaSecurityContextHelper().createPrincipal(this.request.getContext().getRealm(), (Principal)this.authenticatedPrincipal, roles, (KeycloakSecurityContext)securityContext);
            this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
            this.request.setUserPrincipal((Principal)principal);
            this.request.setAuthType("KEYCLOAK");
            return true;
        }
        return false;
    }

    public void saveAccountInfo(KeycloakAccount account) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)securityContext);
    }

    public void logout() {
        CookieTokenStore.removeCookie((HttpFacade)this.facade);
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext secContext) {
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)secContext);
    }

    protected KeycloakPrincipal<RefreshableKeycloakSecurityContext> checkPrincipalFromCookie() {
        KeycloakPrincipal principal = CookieTokenStore.getPrincipalFromCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (AdapterTokenStore)this);
        if (principal == null) {
            log.debug((Object)"Account was not in cookie or was invalid");
            return null;
        }
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            return principal;
        }
        boolean success = session.refreshExpiredToken(false);
        if (success && session.isActive()) {
            return principal;
        }
        log.debugf("Cleanup and expire cookie for user %s after failed refresh", (Object)principal.getName());
        this.request.setUserPrincipal(null);
        this.request.setAuthType(null);
        CookieTokenStore.removeCookie((HttpFacade)this.facade);
        return null;
    }
}

