/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import java.security.Principal;
import java.util.Set;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.as7.CatalinaRequestAuthenticator;
import org.keycloak.adapters.as7.CatalinaSecurityContextHelper;
import org.keycloak.adapters.as7.CatalinaUserSessionManagement;

public class CatalinaSessionTokenStore
implements AdapterTokenStore {
    private static final Logger log = Logger.getLogger(CatalinaSessionTokenStore.class);
    private Request request;
    private KeycloakDeployment deployment;
    private CatalinaUserSessionManagement sessionManagement;

    public CatalinaSessionTokenStore(Request request, KeycloakDeployment deployment, CatalinaUserSessionManagement sessionManagement) {
        this.request = request;
        this.deployment = deployment;
        this.sessionManagement = sessionManagement;
    }

    public void checkCurrentToken() {
        if (this.request.getSessionInternal(false) == null || this.request.getSessionInternal().getPrincipal() == null) {
            return;
        }
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)this.request.getSessionInternal().getNote(KeycloakSecurityContext.class.getName());
        if (session == null) {
            return;
        }
        if (session.getDeployment() == null) {
            session.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
        }
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = session.refreshExpiredToken(false);
        if (success && session.isActive()) {
            return;
        }
        Session catalinaSession = this.request.getSessionInternal();
        log.debugf("Cleanup and expire session %s after failed refresh", (Object)catalinaSession.getId());
        catalinaSession.removeNote(KeycloakSecurityContext.class.getName());
        this.request.setUserPrincipal(null);
        this.request.setAuthType(null);
        catalinaSession.setPrincipal(null);
        catalinaSession.setAuthType(null);
        catalinaSession.expire();
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        if (this.request.getSessionInternal(false) == null || this.request.getSessionInternal().getPrincipal() == null) {
            return false;
        }
        log.debug((Object)"remote logged in already. Establish state from session");
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)this.request.getSessionInternal().getNote(KeycloakSecurityContext.class.getName());
        if (securityContext != null) {
            if (!this.deployment.getRealm().equals(securityContext.getRealm())) {
                log.debug((Object)"Account from cookie is from a different realm than for the request.");
                return false;
            }
            securityContext.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
            this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        }
        GenericPrincipal principal = (GenericPrincipal)this.request.getSessionInternal().getPrincipal();
        this.request.setUserPrincipal((Principal)principal);
        this.request.setAuthType("KEYCLOAK");
        ((CatalinaRequestAuthenticator)authenticator).restoreRequest();
        return true;
    }

    public void saveAccountInfo(KeycloakAccount account) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        Set roles = account.getRoles();
        GenericPrincipal principal = new CatalinaSecurityContextHelper().createPrincipal(this.request.getContext().getRealm(), account.getPrincipal(), roles, (KeycloakSecurityContext)securityContext);
        Session session = this.request.getSessionInternal(true);
        session.setPrincipal((Principal)principal);
        session.setAuthType("OAUTH");
        session.setNote(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        String username = securityContext.getToken().getSubject();
        log.debug((Object)("userSessionManagement.login: " + username));
        this.sessionManagement.login(session);
    }

    public void logout() {
        Session session = this.request.getSessionInternal(false);
        if (session != null) {
            session.removeNote(KeycloakSecurityContext.class.getName());
        }
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
    }
}

