/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.logging.Logger;
import org.keycloak.adapters.UserSessionManagement;

public class CatalinaUserSessionManagement
implements SessionListener,
UserSessionManagement {
    private static final Logger log = Logger.getLogger(CatalinaUserSessionManagement.class);
    protected ConcurrentHashMap<String, UserSessions> userSessionMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveSessions() {
        int active = 0;
        ConcurrentHashMap<String, UserSessions> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            for (UserSessions sessions : this.userSessionMap.values()) {
                active += sessions.getSessions().size();
            }
        }
        return active;
    }

    public Long getUserLoginTime(String username) {
        UserSessions sessions = this.userSessionMap.get(username);
        if (sessions == null) {
            return null;
        }
        return sessions.getLoggedIn();
    }

    public Set<String> getActiveUsers() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.userSessionMap.keySet());
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void login(Session session, String username) {
        ConcurrentHashMap<String, UserSessions> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            UserSessions userSessions = this.userSessionMap.get(username);
            if (userSessions == null) {
                userSessions = new UserSessions();
                this.userSessionMap.put(username, userSessions);
            }
            userSessions.getSessions().put(session.getId(), session);
        }
        session.addSessionListener((SessionListener)this);
    }

    public void logoutAll() {
        ArrayList users = new ArrayList();
        users.addAll(this.userSessionMap.keySet());
        for (String user : users) {
            this.logout(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String user) {
        log.debug((Object)("logoutUser: " + user));
        UserSessions sessions = null;
        ConcurrentHashMap<String, UserSessions> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            sessions = this.userSessionMap.remove(user);
        }
        if (sessions == null) {
            log.debug((Object)("no session for user: " + user));
            return;
        }
        log.debug((Object)"found session for user");
        for (Session session : sessions.getSessions().values()) {
            session.setPrincipal(null);
            session.setAuthType(null);
            session.getSession().invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType()) && !"passivateSession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        GenericPrincipal principal = (GenericPrincipal)session.getPrincipal();
        if (principal == null) {
            return;
        }
        session.setPrincipal(null);
        session.setAuthType(null);
        String username = principal.getUserPrincipal().getName();
        ConcurrentHashMap<String, UserSessions> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            UserSessions sessions = this.userSessionMap.get(username);
            if (sessions != null) {
                sessions.getSessions().remove(session.getId());
                if (sessions.getSessions().isEmpty()) {
                    this.userSessionMap.remove(username);
                }
            }
        }
    }

    public static class UserSessions {
        protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
        protected long loggedIn = System.currentTimeMillis();

        public Map<String, Session> getSessions() {
            return this.sessions;
        }

        public long getLoggedIn() {
            return this.loggedIn;
        }
    }
}

