/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface UserResource {
    @GET
    public UserRepresentation toRepresentation();

    @PUT
    public void update(UserRepresentation var1);

    @DELETE
    public void remove();

    @POST
    @Path(value="logout")
    public void logout();

    @PUT
    @Path(value="remove-totp")
    public void removeTotp();

    @PUT
    @Path(value="reset-password")
    public void resetPassword(CredentialRepresentation var1);

    @PUT
    @Path(value="reset-password-email")
    public void resetPasswordEmail();

    @PUT
    @Path(value="reset-password-email")
    public void resetPasswordEmail(@QueryParam(value="client_id") String var1);

    @PUT
    @Path(value="send-verify-email")
    public void sendVerifyEmail();

    @PUT
    @Path(value="send-verify-email")
    public void sendVerifyEmail(@QueryParam(value="client_id") String var1);

    @GET
    @Path(value="sessions")
    public List<UserSessionRepresentation> getUserSessions();

    @GET
    @Path(value="federated-identity")
    public List<FederatedIdentityRepresentation> getFederatedIdentity();

    @POST
    @Path(value="federated-identity/{provider}")
    public Response addFederatedIdentity(@PathParam(value="provider") String var1, FederatedIdentityRepresentation var2);

    @Path(value="federated-identity/{provider}")
    @DELETE
    public void removeFederatedIdentity(@PathParam(value="provider") String var1);

    @Path(value="role-mappings")
    public RoleMappingResource roles();
}

