/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Map;

public class CreatedResponseUtil {
    public static String getCreatedId(Response response) throws WebApplicationException {
        URI location = response.getLocation();
        if (!response.getStatusInfo().equals(Response.Status.CREATED)) {
            Response.StatusType statusInfo = response.getStatusInfo();
            String contentType = response.getHeaderString("Content-Type");
            String errorMessage = "Create method returned status " + statusInfo.getReasonPhrase() + " (Code: " + statusInfo.getStatusCode() + "); expected status: Created (201).";
            try {
                Map responseBody;
                if (CreatedResponseUtil.matches(MediaType.APPLICATION_JSON_TYPE, MediaType.valueOf((String)contentType)) && (responseBody = (Map)response.readEntity(Map.class)) != null) {
                    if (responseBody.containsKey("errorMessage")) {
                        errorMessage = errorMessage + " ErrorMessage: " + responseBody.get("errorMessage");
                    }
                    if (responseBody.containsKey("error")) {
                        errorMessage = errorMessage + " Error: " + responseBody.get("error");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new WebApplicationException(errorMessage, response);
        }
        if (location == null) {
            return null;
        }
        String path = location.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private static boolean matches(MediaType a, MediaType b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.getType().equalsIgnoreCase(b.getType()) && a.getSubtype().equalsIgnoreCase(b.getSubtype());
    }
}

