/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jws;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.crypto.SecretKey;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Base64Url;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.crypto.HMACProvider;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.util.JsonSerialization;

public class JWSBuilder {
    protected String type;
    protected String kid;
    protected String x5t;
    protected JWK jwk;
    protected List<X509Certificate> x5c;
    protected String contentType;
    protected byte[] contentBytes;

    public JWSBuilder type(String type) {
        this.type = type;
        return this;
    }

    public JWSBuilder kid(String kid) {
        this.kid = kid;
        return this;
    }

    public JWSBuilder x5t(String x5t) {
        this.x5t = x5t;
        return this;
    }

    public JWSBuilder jwk(JWK jwk) {
        this.jwk = jwk;
        return this;
    }

    public JWSBuilder x5c(List<X509Certificate> x5c) {
        this.x5c = x5c;
        return this;
    }

    public JWSBuilder contentType(String type) {
        this.contentType = type;
        return this;
    }

    public EncodingBuilder content(byte[] bytes) {
        this.contentBytes = bytes;
        return new EncodingBuilder();
    }

    public EncodingBuilder jsonContent(Object object) {
        try {
            this.contentBytes = JsonSerialization.writeValueAsBytes(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new EncodingBuilder();
    }

    protected String encodeHeader(String sigAlgName) {
        StringBuilder builder = new StringBuilder("{");
        if ("Ed25519".equals(sigAlgName) || "Ed448".equals(sigAlgName)) {
            builder.append("\"alg\":\"").append("EdDSA").append("\"");
            builder.append(",\"crv\":\"").append(sigAlgName).append("\"");
        } else {
            builder.append("\"alg\":\"").append(sigAlgName).append("\"");
        }
        if (this.type != null) {
            builder.append(",\"typ\" : \"").append(this.type).append("\"");
        }
        if (this.kid != null) {
            builder.append(",\"kid\" : \"").append(this.kid).append("\"");
        }
        if (this.x5t != null) {
            builder.append(",\"x5t\" : \"").append(this.x5t).append("\"");
        }
        if (this.x5c != null && !this.x5c.isEmpty()) {
            builder.append(",\"x5c\" : [");
            for (int i = 0; i < this.x5c.size(); ++i) {
                X509Certificate certificate = this.x5c.get(i);
                if (i > 0) {
                    builder.append(",");
                }
                try {
                    builder.append("\"").append(Base64.encodeBytes(certificate.getEncoded())).append("\"");
                    continue;
                }
                catch (CertificateEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            builder.append("]");
        }
        if (this.jwk != null) {
            try {
                builder.append(",\"jwk\" : ").append(JsonSerialization.mapper.writeValueAsString(this.jwk));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.contentType != null) {
            builder.append(",\"cty\":\"").append(this.contentType).append("\"");
        }
        builder.append("}");
        return Base64Url.encode(builder.toString().getBytes(StandardCharsets.UTF_8));
    }

    protected String encodeAll(StringBuilder encoding, byte[] signature) {
        encoding.append('.');
        if (signature != null) {
            encoding.append(Base64Url.encode(signature));
        }
        return encoding.toString();
    }

    protected void encode(Algorithm alg, byte[] data, StringBuilder encoding) {
        this.encode(alg.name(), data, encoding);
    }

    protected void encode(String sigAlgName, byte[] data, StringBuilder encoding) {
        encoding.append(this.encodeHeader(sigAlgName));
        encoding.append('.');
        encoding.append(Base64Url.encode(data));
    }

    protected byte[] marshalContent() {
        return this.contentBytes;
    }

    public class EncodingBuilder {
        public String sign(SignatureSignerContext signer) {
            JWSBuilder.this.kid = signer.getKid();
            StringBuilder buffer = new StringBuilder();
            byte[] data = JWSBuilder.this.marshalContent();
            JWSBuilder.this.encode(signer.getAlgorithm(), data, buffer);
            byte[] signature = null;
            try {
                signature = signer.sign(buffer.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return JWSBuilder.this.encodeAll(buffer, signature);
        }

        public String none() {
            StringBuilder buffer = new StringBuilder();
            byte[] data = JWSBuilder.this.marshalContent();
            JWSBuilder.this.encode(Algorithm.none, data, buffer);
            return JWSBuilder.this.encodeAll(buffer, null);
        }

        @Deprecated
        public String sign(Algorithm algorithm, PrivateKey privateKey) {
            StringBuilder buffer = new StringBuilder();
            byte[] data = JWSBuilder.this.marshalContent();
            JWSBuilder.this.encode(algorithm, data, buffer);
            byte[] signature = RSAProvider.sign(buffer.toString().getBytes(StandardCharsets.UTF_8), algorithm, privateKey);
            return JWSBuilder.this.encodeAll(buffer, signature);
        }

        @Deprecated
        public String rsa256(PrivateKey privateKey) {
            return this.sign(Algorithm.RS256, privateKey);
        }

        @Deprecated
        public String rsa384(PrivateKey privateKey) {
            return this.sign(Algorithm.RS384, privateKey);
        }

        @Deprecated
        public String rsa512(PrivateKey privateKey) {
            return this.sign(Algorithm.RS512, privateKey);
        }

        @Deprecated
        public String hmac256(byte[] sharedSecret) {
            StringBuilder buffer = new StringBuilder();
            byte[] data = JWSBuilder.this.marshalContent();
            JWSBuilder.this.encode(Algorithm.HS256, data, buffer);
            byte[] signature = HMACProvider.sign(buffer.toString().getBytes(StandardCharsets.UTF_8), Algorithm.HS256, sharedSecret);
            return JWSBuilder.this.encodeAll(buffer, signature);
        }

        @Deprecated
        public String hmac384(byte[] sharedSecret) {
            StringBuilder buffer = new StringBuilder();
            byte[] data = JWSBuilder.this.marshalContent();
            JWSBuilder.this.encode(Algorithm.HS384, data, buffer);
            byte[] signature = HMACProvider.sign(buffer.toString().getBytes(StandardCharsets.UTF_8), Algorithm.HS384, sharedSecret);
            return JWSBuilder.this.encodeAll(buffer, signature);
        }

        @Deprecated
        public String hmac512(byte[] sharedSecret) {
            StringBuilder buffer = new StringBuilder();
            byte[] data = JWSBuilder.this.marshalContent();
            JWSBuilder.this.encode(Algorithm.HS512, data, buffer);
            byte[] signature = HMACProvider.sign(buffer.toString().getBytes(StandardCharsets.UTF_8), Algorithm.HS512, sharedSecret);
            return JWSBuilder.this.encodeAll(buffer, signature);
        }

        @Deprecated
        public String hmac256(SecretKey sharedSecret) {
            StringBuilder buffer = new StringBuilder();
            byte[] data = JWSBuilder.this.marshalContent();
            JWSBuilder.this.encode(Algorithm.HS256, data, buffer);
            byte[] signature = HMACProvider.sign(buffer.toString().getBytes(StandardCharsets.UTF_8), Algorithm.HS256, sharedSecret);
            return JWSBuilder.this.encodeAll(buffer, signature);
        }

        @Deprecated
        public String hmac384(SecretKey sharedSecret) {
            StringBuilder buffer = new StringBuilder();
            byte[] data = JWSBuilder.this.marshalContent();
            JWSBuilder.this.encode(Algorithm.HS384, data, buffer);
            byte[] signature = HMACProvider.sign(buffer.toString().getBytes(StandardCharsets.UTF_8), Algorithm.HS384, sharedSecret);
            return JWSBuilder.this.encodeAll(buffer, signature);
        }

        @Deprecated
        public String hmac512(SecretKey sharedSecret) {
            StringBuilder buffer = new StringBuilder();
            byte[] data = JWSBuilder.this.marshalContent();
            JWSBuilder.this.encode(Algorithm.HS512, data, buffer);
            byte[] signature = HMACProvider.sign(buffer.toString().getBytes(StandardCharsets.UTF_8), Algorithm.HS512, sharedSecret);
            return JWSBuilder.this.encodeAll(buffer, signature);
        }
    }
}

