/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.keycloak.adapters.authorization.PathCache;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.representation.ResourceRepresentation;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

class PathMatcher {
    private static final char WILDCARD = '*';
    private final AuthzClient authzClient;
    private PathCache cache = new PathCache(100, 30000L);

    public PathMatcher(AuthzClient authzClient) {
        this.authzClient = authzClient;
    }

    public PolicyEnforcerConfig.PathConfig matches(String targetUri, Map<String, PolicyEnforcerConfig.PathConfig> paths) {
        PolicyEnforcerConfig.PathConfig pathConfig;
        PolicyEnforcerConfig.PathConfig pathConfig2 = pathConfig = paths.get(targetUri) == null ? this.cache.get(targetUri) : paths.get(targetUri);
        if (pathConfig != null) {
            return pathConfig;
        }
        PolicyEnforcerConfig.PathConfig matchingAnyPath = null;
        PolicyEnforcerConfig.PathConfig matchingAnySuffixPath = null;
        for (PolicyEnforcerConfig.PathConfig entry : paths.values()) {
            String protectedSuffix;
            String pathString;
            String templateUri;
            String expectedUri = entry.getPath();
            String matchingUri = null;
            if (this.exactMatch(expectedUri, targetUri, expectedUri)) {
                matchingUri = expectedUri;
            }
            if (this.isTemplate(expectedUri) && (templateUri = this.buildUriFromTemplate(expectedUri, targetUri)) != null && this.exactMatch(expectedUri, targetUri, templateUri)) {
                matchingUri = templateUri;
                entry = this.resolvePathConfig(entry, targetUri);
            }
            if (matchingUri == null) continue;
            StringBuilder path = new StringBuilder(expectedUri);
            int patternIndex = path.indexOf("/*");
            if (patternIndex != -1) {
                path.delete(patternIndex, path.length());
            }
            if ((patternIndex = path.indexOf("{")) != -1) {
                path.delete(patternIndex, path.length());
            }
            if ("".equals(pathString = path.toString())) {
                pathString = "/";
            }
            if (matchingUri.equals(targetUri) || pathString.equals(targetUri)) {
                this.cache.put(targetUri, entry);
                return entry;
            }
            if ('*' == expectedUri.charAt(expectedUri.length() - 1)) {
                if (matchingAnyPath != null && matchingAnyPath.getPath().length() >= matchingUri.length()) continue;
                matchingAnyPath = entry;
                continue;
            }
            int suffixIndex = expectedUri.indexOf("*.");
            if (suffixIndex == -1 || !targetUri.endsWith(protectedSuffix = expectedUri.substring(suffixIndex + 1))) continue;
            matchingAnySuffixPath = entry;
        }
        if (matchingAnySuffixPath != null) {
            this.cache.put(targetUri, matchingAnySuffixPath);
            return matchingAnySuffixPath;
        }
        if (matchingAnyPath != null) {
            this.cache.put(targetUri, matchingAnyPath);
        }
        return matchingAnyPath;
    }

    private boolean exactMatch(String expectedUri, String targetUri, String value) {
        if (targetUri.equals(value)) {
            return value.equals(targetUri);
        }
        if (this.endsWithWildcard(expectedUri)) {
            return targetUri.startsWith(expectedUri.substring(0, expectedUri.length() - 2));
        }
        String suffix = "/*.";
        int suffixIndex = expectedUri.indexOf(suffix);
        if (suffixIndex != -1) {
            return targetUri.endsWith(expectedUri.substring(suffixIndex + suffix.length() - 1));
        }
        return false;
    }

    public String buildUriFromTemplate(String expectedUri, String targetUri) {
        int patternStartIndex = expectedUri.indexOf("{");
        if (patternStartIndex == -1 || patternStartIndex >= targetUri.length()) {
            return null;
        }
        if (expectedUri.split("/").length > targetUri.split("/").length) {
            return null;
        }
        char[] expectedUriChars = expectedUri.toCharArray();
        char[] matchingUri = Arrays.copyOfRange(expectedUriChars, 0, patternStartIndex);
        int matchingUriLastIndex = matchingUri.length;
        String targetUriParams = targetUri.substring(patternStartIndex);
        if (Arrays.equals(matchingUri, Arrays.copyOf(targetUri.toCharArray(), matchingUri.length))) {
            matchingUri = Arrays.copyOf(matchingUri, targetUri.length());
            int paramIndex = 0;
            for (int i = patternStartIndex; i < expectedUriChars.length && matchingUriLastIndex < matchingUri.length; ++i) {
                char c = expectedUriChars[i];
                if (c == '{' || c == '*') {
                    String[] params = targetUriParams.split("/");
                    for (int k = paramIndex; k <= (c == '*' ? params.length : paramIndex) && k != params.length; ++k) {
                        int paramLength = params[k].length();
                        if (matchingUriLastIndex + paramLength > matchingUri.length) {
                            return null;
                        }
                        for (int j = 0; j < paramLength; ++j) {
                            matchingUri[matchingUriLastIndex++] = params[k].charAt(j);
                        }
                        if (c != '*' || matchingUriLastIndex >= matchingUri.length) continue;
                        matchingUri[matchingUriLastIndex++] = 47;
                    }
                    i = expectedUri.indexOf(125, i);
                    continue;
                }
                if (c == '/') {
                    ++paramIndex;
                }
                matchingUri[matchingUriLastIndex++] = c;
            }
            if (matchingUri[matchingUri.length - 1] == '\u0000') {
                return null;
            }
            return String.valueOf(matchingUri);
        }
        return null;
    }

    public boolean endsWithWildcard(String expectedUri) {
        return '*' == expectedUri.charAt(expectedUri.length() - 1);
    }

    private boolean isTemplate(String uri) {
        return uri.indexOf("{") != -1;
    }

    private PolicyEnforcerConfig.PathConfig resolvePathConfig(PolicyEnforcerConfig.PathConfig originalConfig, String path) {
        ProtectedResource resource;
        List search;
        if (originalConfig.hasPattern() && !(search = (resource = this.authzClient.protection().resource()).findByUri(path)).isEmpty()) {
            ResourceRepresentation targetResource = (ResourceRepresentation)search.get(0);
            PolicyEnforcerConfig.PathConfig config = PolicyEnforcer.createPathConfig(targetResource);
            config.setScopes(originalConfig.getScopes());
            config.setMethods(originalConfig.getMethods());
            config.setParentConfig(originalConfig);
            config.setEnforcementMode(originalConfig.getEnforcementMode());
            return config;
        }
        return originalConfig;
    }
}

