/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.AbstractPolicyEnforcer;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.representation.PermissionRequest;
import org.keycloak.authorization.client.resource.PermissionResource;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

public class BearerTokenPolicyEnforcer
extends AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(BearerTokenPolicyEnforcer.class);

    public BearerTokenPolicyEnforcer(PolicyEnforcer enforcer) {
        super(enforcer);
    }

    @Override
    protected boolean challenge(PolicyEnforcerConfig.PathConfig pathConfig, Set<String> requiredScopes, OIDCHttpFacade facade) {
        if (this.getEnforcerConfig().getUserManagedAccess() != null) {
            this.challengeUmaAuthentication(pathConfig, requiredScopes, facade);
        } else {
            this.challengeEntitlementAuthentication(facade);
        }
        return true;
    }

    private void challengeEntitlementAuthentication(OIDCHttpFacade facade) {
        HttpFacade.Response response = facade.getResponse();
        AuthzClient authzClient = this.getAuthzClient();
        String clientId = authzClient.getConfiguration().getClientId();
        String authorizationServerUri = authzClient.getServerConfiguration().getIssuer().toString() + "/authz/entitlement";
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "KC_ETT realm=\"" + clientId + "\",as_uri=\"" + authorizationServerUri + "\"");
    }

    private void challengeUmaAuthentication(PolicyEnforcerConfig.PathConfig pathConfig, Set<String> requiredScopes, OIDCHttpFacade facade) {
        HttpFacade.Response response = facade.getResponse();
        AuthzClient authzClient = this.getAuthzClient();
        String ticket = this.getPermissionTicket(pathConfig, requiredScopes, authzClient);
        String clientId = authzClient.getConfiguration().getClientId();
        String authorizationServerUri = authzClient.getServerConfiguration().getIssuer().toString() + "/authz/authorize";
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "UMA realm=\"" + clientId + "\",as_uri=\"" + authorizationServerUri + "\",ticket=\"" + ticket + "\"");
    }

    private String getPermissionTicket(PolicyEnforcerConfig.PathConfig pathConfig, Set<String> requiredScopes, AuthzClient authzClient) {
        ProtectionResource protection = authzClient.protection();
        PermissionResource permission = protection.permission();
        PermissionRequest permissionRequest = new PermissionRequest();
        permissionRequest.setResourceSetId(pathConfig.getId());
        permissionRequest.setScopes(requiredScopes);
        return permission.forResource(permissionRequest).getTicket();
    }
}

