/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.BearerTokenPolicyEnforcer;
import org.keycloak.adapters.authorization.KeycloakAdapterPolicyEnforcer;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.RegistrationResponse;
import org.keycloak.authorization.client.representation.ResourceRepresentation;
import org.keycloak.authorization.client.representation.ScopeRepresentation;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.Permission;

public class PolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(PolicyEnforcer.class);
    private final KeycloakDeployment deployment;
    private final AuthzClient authzClient;
    private final PolicyEnforcerConfig enforcerConfig;
    private final Map<String, PolicyEnforcerConfig.PathConfig> paths;

    public PolicyEnforcer(KeycloakDeployment deployment, AdapterConfig adapterConfig) {
        this.deployment = deployment;
        this.enforcerConfig = adapterConfig.getPolicyEnforcerConfig();
        this.authzClient = AuthzClient.create((Configuration)new Configuration(adapterConfig.getAuthServerUrl(), adapterConfig.getRealm(), adapterConfig.getResource(), adapterConfig.getCredentials(), deployment.getClient()));
        this.paths = this.configurePaths(this.authzClient.protection().resource(), this.enforcerConfig);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initialization complete. Path configurations:");
            for (PolicyEnforcerConfig.PathConfig pathConfig : this.paths.values()) {
                LOGGER.debug((Object)pathConfig);
            }
        }
    }

    public AuthorizationContext enforce(OIDCHttpFacade facade) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement is enable. Enforcing policy decisions for path [{0}].", (Object)facade.getRequest().getURI());
        }
        AuthorizationContext context = this.deployment.isBearerOnly() ? new BearerTokenPolicyEnforcer(this).authorize(facade) : new KeycloakAdapterPolicyEnforcer(this).authorize(facade);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement result for path [{0}] is : {1}", (Object)facade.getRequest().getURI(), (Object)(context.isGranted() ? "GRANTED" : "DENIED"));
            LOGGER.debugv("Returning authorization context with permissions:", new Object[0]);
            for (Permission permission : context.getPermissions()) {
                LOGGER.debug((Object)permission);
            }
        }
        return context;
    }

    PolicyEnforcerConfig getEnforcerConfig() {
        return this.enforcerConfig;
    }

    AuthzClient getClient() {
        return this.authzClient;
    }

    public Map<String, PolicyEnforcerConfig.PathConfig> getPaths() {
        return this.paths;
    }

    void addPath(PolicyEnforcerConfig.PathConfig pathConfig) {
        this.paths.put(pathConfig.getPath(), pathConfig);
    }

    KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configurePaths(ProtectedResource protectedResource, PolicyEnforcerConfig enforcerConfig) {
        boolean loadPathsFromServer = true;
        for (PolicyEnforcerConfig.PathConfig pathConfig : enforcerConfig.getPaths()) {
            if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) continue;
            loadPathsFromServer = false;
            break;
        }
        if (loadPathsFromServer) {
            LOGGER.info((Object)"No path provided in configuration.");
            return this.configureAllPathsForResourceServer(protectedResource);
        }
        LOGGER.info((Object)"Paths provided in configuration.");
        return this.configureDefinedPaths(protectedResource, enforcerConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, PolicyEnforcerConfig.PathConfig> configureDefinedPaths(ProtectedResource protectedResource, PolicyEnforcerConfig enforcerConfig) {
        Map<String, PolicyEnforcerConfig.PathConfig> paths = Collections.synchronizedMap(new HashMap());
        for (PolicyEnforcerConfig.PathConfig pathConfig : enforcerConfig.getPaths()) {
            Set search;
            String resourceName = pathConfig.getName();
            String path = pathConfig.getPath();
            if (resourceName != null) {
                LOGGER.debugf("Trying to find resource with name [%s] for path [%s].", (Object)resourceName, (Object)path);
                search = protectedResource.findByFilter("name=" + resourceName);
            } else {
                LOGGER.debugf("Trying to find resource with uri [%s] for path [%s].", (Object)path, (Object)path);
                search = protectedResource.findByFilter("uri=" + path);
            }
            if (search.isEmpty()) {
                if (!enforcerConfig.isCreateResources().booleanValue()) throw new RuntimeException("Could not find matching resource on server with uri [" + path + "] or name [" + resourceName + "]. Make sure you have created a resource on the server that matches with the path configuration.");
                LOGGER.debugf("Creating resource on server for path [%s].", (Object)pathConfig);
                ResourceRepresentation resource = new ResourceRepresentation();
                resource.setName(resourceName);
                resource.setType(pathConfig.getType());
                resource.setUri(path);
                HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>();
                for (String scopeName : pathConfig.getScopes()) {
                    ScopeRepresentation scope = new ScopeRepresentation();
                    scope.setName(scopeName);
                    scopes.add(scope);
                }
                resource.setScopes(scopes);
                RegistrationResponse registrationResponse = protectedResource.create(resource);
                pathConfig.setId(registrationResponse.getId());
            } else {
                pathConfig.setId((String)search.iterator().next());
            }
            PolicyEnforcerConfig.PathConfig existingPath = null;
            for (PolicyEnforcerConfig.PathConfig current : paths.values()) {
                if (!current.getId().equals(pathConfig.getId()) || !current.getPath().equals(pathConfig.getPath())) continue;
                existingPath = current;
                break;
            }
            if (existingPath == null) {
                paths.put(pathConfig.getPath(), pathConfig);
                continue;
            }
            existingPath.getMethods().addAll(pathConfig.getMethods());
            existingPath.getScopes().addAll(pathConfig.getScopes());
        }
        return paths;
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configureAllPathsForResourceServer(ProtectedResource protectedResource) {
        LOGGER.info((Object)"Querying the server for all resources associated with this application.");
        Map<String, PolicyEnforcerConfig.PathConfig> paths = Collections.synchronizedMap(new HashMap());
        for (String id : protectedResource.findAll()) {
            RegistrationResponse response = protectedResource.findById(id);
            ResourceRepresentation resourceDescription = response.getResourceDescription();
            if (resourceDescription.getUri() == null) continue;
            PolicyEnforcerConfig.PathConfig pathConfig = PolicyEnforcer.createPathConfig(resourceDescription);
            paths.put(pathConfig.getPath(), pathConfig);
        }
        return paths;
    }

    static PolicyEnforcerConfig.PathConfig createPathConfig(ResourceRepresentation resourceDescription) {
        PolicyEnforcerConfig.PathConfig pathConfig = new PolicyEnforcerConfig.PathConfig();
        pathConfig.setId(resourceDescription.getId());
        pathConfig.setName(resourceDescription.getName());
        pathConfig.setPath(resourceDescription.getUri());
        ArrayList<String> scopeNames = new ArrayList<String>();
        for (ScopeRepresentation scope : resourceDescription.getScopes()) {
            scopeNames.add(scope.getName());
        }
        pathConfig.setScopes(scopeNames);
        pathConfig.setType(resourceDescription.getType());
        return pathConfig;
    }
}

