/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.PathMatcher;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.representation.ResourceRepresentation;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.Permission;

public abstract class AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(AbstractPolicyEnforcer.class);
    private final PolicyEnforcerConfig enforcerConfig;
    private final PolicyEnforcer policyEnforcer;
    private List<PolicyEnforcerConfig.PathConfig> paths;
    private AuthzClient authzClient;
    private PathMatcher pathMatcher;

    public AbstractPolicyEnforcer(PolicyEnforcer policyEnforcer) {
        this.policyEnforcer = policyEnforcer;
        this.enforcerConfig = policyEnforcer.getEnforcerConfig();
        this.authzClient = policyEnforcer.getClient();
        this.pathMatcher = new PathMatcher();
        this.paths = new ArrayList<PolicyEnforcerConfig.PathConfig>(policyEnforcer.getPaths());
    }

    public AuthorizationContext authorize(OIDCHttpFacade httpFacade) {
        AccessToken accessToken;
        PolicyEnforcerConfig.EnforcementMode enforcementMode = this.enforcerConfig.getEnforcementMode();
        if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)enforcementMode)) {
            return this.createEmptyAuthorizationContext(true);
        }
        KeycloakSecurityContext securityContext = httpFacade.getSecurityContext();
        if (securityContext != null && (accessToken = securityContext.getToken()) != null) {
            Set<String> requiredScopes;
            HttpFacade.Request request = httpFacade.getRequest();
            HttpFacade.Response response = httpFacade.getResponse();
            String pathInfo = URI.create(request.getURI()).getPath().substring(1);
            String path = pathInfo.substring(pathInfo.indexOf(47), pathInfo.length());
            PolicyEnforcerConfig.PathConfig pathConfig = this.pathMatcher.matches(path, this.paths);
            LOGGER.debugf("Checking permissions for path [%s] with config [%s].", (Object)request.getURI(), (Object)pathConfig);
            if (pathConfig == null) {
                if (PolicyEnforcerConfig.EnforcementMode.PERMISSIVE.equals((Object)enforcementMode)) {
                    return this.createAuthorizationContext(accessToken);
                }
                LOGGER.debugf("Could not find a configuration for path [%s]", (Object)path);
                response.sendError(403, "Could not find a configuration for path [" + path + "].");
                return this.createEmptyAuthorizationContext(false);
            }
            if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) {
                return this.createEmptyAuthorizationContext(true);
            }
            PolicyEnforcerConfig.PathConfig actualPathConfig = this.resolvePathConfig(pathConfig, request);
            if (this.isAuthorized(actualPathConfig, requiredScopes = this.getRequiredScopes(actualPathConfig, request), accessToken, httpFacade)) {
                try {
                    return this.createAuthorizationContext(accessToken);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error processing path [" + actualPathConfig.getPath() + "].", e);
                }
            }
            if (!this.challenge(actualPathConfig, requiredScopes, httpFacade)) {
                LOGGER.debugf("Sending challenge to the client. Path [%s]", (Object)pathConfig);
                response.sendError(403, "Authorization failed.");
            }
        }
        return this.createEmptyAuthorizationContext(false);
    }

    protected abstract boolean challenge(PolicyEnforcerConfig.PathConfig var1, Set<String> var2, OIDCHttpFacade var3);

    protected boolean isAuthorized(PolicyEnforcerConfig.PathConfig actualPathConfig, Set<String> requiredScopes, AccessToken accessToken, OIDCHttpFacade httpFacade) {
        HttpFacade.Request request = httpFacade.getRequest();
        PolicyEnforcerConfig enforcerConfig = this.getEnforcerConfig();
        String accessDeniedPath = enforcerConfig.getOnDenyRedirectTo();
        if (accessDeniedPath != null && request.getURI().contains(accessDeniedPath)) {
            return true;
        }
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        List permissions = authorization.getPermissions();
        boolean hasPermission = false;
        for (Permission permission : permissions) {
            if (permission.getResourceSetId() != null) {
                if (!this.isResourcePermission(actualPathConfig, permission)) continue;
                hasPermission = true;
                if (actualPathConfig.isInstance() && !this.matchResourcePermission(actualPathConfig, permission) || !this.hasResourceScopePermission(requiredScopes, permission, actualPathConfig)) continue;
                LOGGER.debugf("Authorization GRANTED for path [%s]. Permissions [%s].", (Object)actualPathConfig, (Object)permissions);
                if (request.getMethod().equalsIgnoreCase("DELETE") && actualPathConfig.isInstance()) {
                    this.paths.remove(actualPathConfig);
                }
                return true;
            }
            if (!this.hasResourceScopePermission(requiredScopes, permission, actualPathConfig)) continue;
            hasPermission = true;
            return true;
        }
        if (!hasPermission && PolicyEnforcerConfig.EnforcementMode.PERMISSIVE.equals((Object)actualPathConfig.getEnforcementMode())) {
            return true;
        }
        LOGGER.debugf("Authorization FAILED for path [%s]. No enough permissions [%s].", (Object)actualPathConfig, (Object)permissions);
        return false;
    }

    private boolean hasResourceScopePermission(Set<String> requiredScopes, Permission permission, PolicyEnforcerConfig.PathConfig actualPathConfig) {
        Set allowedScopes = permission.getScopes();
        return allowedScopes.containsAll(requiredScopes) || allowedScopes.isEmpty();
    }

    protected AuthzClient getAuthzClient() {
        return this.authzClient;
    }

    protected PolicyEnforcerConfig getEnforcerConfig() {
        return this.enforcerConfig;
    }

    protected PolicyEnforcer getPolicyEnforcer() {
        return this.policyEnforcer;
    }

    private AuthorizationContext createEmptyAuthorizationContext(final boolean granted) {
        return new AuthorizationContext(){

            public boolean hasPermission(String resourceName, String scopeName) {
                return granted;
            }

            public boolean hasResourcePermission(String resourceName) {
                return granted;
            }

            public boolean hasScopePermission(String scopeName) {
                return granted;
            }

            public List<Permission> getPermissions() {
                return Collections.EMPTY_LIST;
            }

            public boolean isGranted() {
                return granted;
            }
        };
    }

    private PolicyEnforcerConfig.PathConfig resolvePathConfig(PolicyEnforcerConfig.PathConfig originalConfig, HttpFacade.Request request) {
        if (originalConfig.hasPattern()) {
            String pathInfo = URI.create(request.getURI()).getPath().substring(1);
            String path = pathInfo.substring(pathInfo.indexOf(47), pathInfo.length());
            ProtectedResource resource = this.authzClient.protection().resource();
            Set search = resource.findByFilter("uri=" + path);
            if (!search.isEmpty()) {
                ResourceRepresentation targetResource = resource.findById((String)search.iterator().next()).getResourceDescription();
                PolicyEnforcerConfig.PathConfig config = new PolicyEnforcerConfig.PathConfig();
                config.setId(targetResource.getId());
                config.setName(targetResource.getName());
                config.setType(targetResource.getType());
                config.setPath(targetResource.getUri());
                config.setScopes(originalConfig.getScopes());
                config.setMethods(originalConfig.getMethods());
                config.setParentConfig(originalConfig);
                config.setEnforcementMode(originalConfig.getEnforcementMode());
                this.paths.add(config);
                return config;
            }
        }
        return originalConfig;
    }

    private Set<String> getRequiredScopes(PolicyEnforcerConfig.PathConfig pathConfig, HttpFacade.Request request) {
        HashSet<String> requiredScopes = new HashSet<String>();
        requiredScopes.addAll(pathConfig.getScopes());
        String method = request.getMethod();
        for (PolicyEnforcerConfig.MethodConfig methodConfig : pathConfig.getMethods()) {
            if (!methodConfig.getMethod().equals(method)) continue;
            requiredScopes.addAll(methodConfig.getScopes());
        }
        return requiredScopes;
    }

    private AuthorizationContext createAuthorizationContext(AccessToken accessToken) {
        return new AuthorizationContext(accessToken, this.paths);
    }

    private boolean isResourcePermission(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission) {
        boolean resourceMatch = this.matchResourcePermission(actualPathConfig, permission);
        if (!resourceMatch && actualPathConfig.isInstance()) {
            resourceMatch = this.matchResourcePermission(actualPathConfig.getParentConfig(), permission);
        }
        return resourceMatch;
    }

    private boolean matchResourcePermission(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission) {
        return permission.getResourceSetId().equals(actualPathConfig.getId());
    }
}

