/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.representations.AccessToken;
import org.keycloak.util.UriUtils;

public class AuthenticatedActionsHandler {
    private static final Logger log = Logger.getLogger(AuthenticatedActionsHandler.class);
    protected KeycloakDeployment deployment;
    protected HttpFacade facade;

    public AuthenticatedActionsHandler(KeycloakDeployment deployment, HttpFacade facade) {
        this.deployment = deployment;
        this.facade = facade;
    }

    public boolean handledRequest() {
        log.debugv("AuthenticatedActionsValve.invoke {0}", (Object)this.facade.getRequest().getURI());
        if (this.corsRequest()) {
            return true;
        }
        String requestUri = this.facade.getRequest().getURI();
        if (requestUri.endsWith("k_query_bearer_token")) {
            this.queryBearerToken();
            return true;
        }
        return false;
    }

    protected void queryBearerToken() {
        log.debugv("queryBearerToken {0}", (Object)this.facade.getRequest().getURI());
        if (this.abortTokenResponse()) {
            return;
        }
        this.facade.getResponse().setStatus(200);
        this.facade.getResponse().setHeader("Content-Type", "text/plain");
        try {
            this.facade.getResponse().getOutputStream().write(this.facade.getSecurityContext().getTokenString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.facade.getResponse().end();
    }

    protected boolean abortTokenResponse() {
        if (this.facade.getSecurityContext() == null) {
            log.debugv("Not logged in, sending back 401: {0}", (Object)this.facade.getRequest().getURI());
            this.facade.getResponse().setStatus(401);
            this.facade.getResponse().end();
            return true;
        }
        if (!this.deployment.isExposeToken()) {
            this.facade.getResponse().setStatus(200);
            this.facade.getResponse().end();
            return true;
        }
        if (!this.deployment.isCors() && this.facade.getRequest().getHeader("Origin") != null) {
            this.facade.getResponse().setStatus(200);
            this.facade.getResponse().end();
            return true;
        }
        return false;
    }

    protected boolean corsRequest() {
        if (!this.deployment.isCors()) {
            return false;
        }
        KeycloakSecurityContext securityContext = this.facade.getSecurityContext();
        String origin = this.facade.getRequest().getHeader("Origin");
        String requestOrigin = UriUtils.getOrigin((String)this.facade.getRequest().getURI());
        log.debugv("Origin: {0} uri: {1}", (Object)origin, (Object)this.facade.getRequest().getURI());
        if (securityContext != null && origin != null && !origin.equals(requestOrigin)) {
            AccessToken token = securityContext.getToken();
            Set allowedOrigins = token.getAllowedOrigins();
            if (log.isDebugEnabled()) {
                for (String a : allowedOrigins) {
                    log.debug((Object)("   " + a));
                }
            }
            if (allowedOrigins == null || !allowedOrigins.contains("*") && !allowedOrigins.contains(origin)) {
                if (allowedOrigins == null) {
                    log.debugv("allowedOrigins was null in token", new Object[0]);
                } else {
                    log.debugv("allowedOrigins did not contain origin", new Object[0]);
                }
                this.facade.getResponse().setStatus(403);
                this.facade.getResponse().end();
                return true;
            }
            log.debugv("returning origin: {0}", (Object)origin);
            this.facade.getResponse().setStatus(200);
            this.facade.getResponse().setHeader("Access-Control-Allow-Origin", origin);
            this.facade.getResponse().setHeader("Access-Control-Allow-Credentials", "true");
        } else {
            log.debugv("cors validation not needed as we're not a secure session or origin header was null: {0}", (Object)this.facade.getRequest().getURI());
        }
        return false;
    }
}

