/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.security.PublicKey;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.RSATokenVerifier;
import org.keycloak.VerificationException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;

public class RefreshableKeycloakSecurityContext
extends KeycloakSecurityContext {
    protected static Logger log = Logger.getLogger(RefreshableKeycloakSecurityContext.class);
    protected transient KeycloakDeployment deployment;
    protected String refreshToken;

    public RefreshableKeycloakSecurityContext() {
    }

    public RefreshableKeycloakSecurityContext(KeycloakDeployment deployment, String tokenString, AccessToken token, String idTokenString, IDToken idToken, String refreshToken) {
        super(tokenString, token, idTokenString, idToken);
        this.deployment = deployment;
        this.refreshToken = refreshToken;
    }

    public AccessToken getToken() {
        this.refreshExpiredToken();
        return super.getToken();
    }

    public String getTokenString() {
        this.refreshExpiredToken();
        return super.getTokenString();
    }

    public void logout(KeycloakDeployment deployment) {
        try {
            ServerRequest.invokeLogout(deployment, this.refreshToken);
        }
        catch (Exception e) {
            log.error((Object)"failed to invoke remote logout", (Throwable)e);
        }
    }

    public boolean isActive() {
        return this.token.isActive() && this.token.getIssuedAt() > this.deployment.getNotBefore();
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public void refreshExpiredToken() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"checking whether to refresh.");
        }
        if (this.isActive()) {
            return;
        }
        if (this.deployment == null || this.refreshToken == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Doing refresh");
        }
        AccessTokenResponse response = null;
        try {
            response = ServerRequest.invokeRefresh(this.deployment, this.refreshToken);
        }
        catch (IOException e) {
            log.error((Object)"Refresh token failure", (Throwable)e);
            return;
        }
        catch (ServerRequest.HttpFailure httpFailure) {
            log.error((Object)("Refresh token failure status: " + httpFailure.getStatus() + " " + httpFailure.getError()));
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"received refresh response");
        }
        String tokenString = response.getToken();
        AccessToken token = null;
        try {
            token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)this.deployment.getRealmKey(), (String)this.deployment.getRealm());
            log.debug((Object)"Token Verification succeeded!");
        }
        catch (VerificationException e) {
            log.error((Object)"failed verification of token");
        }
        if (response.getNotBeforePolicy() > this.deployment.getNotBefore()) {
            this.deployment.setNotBefore(response.getNotBeforePolicy());
        }
        this.token = token;
        this.refreshToken = response.getRefreshToken();
        this.tokenString = tokenString;
    }
}

