/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.PublicKey;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jboss.logging.Logger;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.idm.PublishedRealmRepresentation;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.KeycloakUriBuilder;

public class AdapterDeploymentContext {
    private static final Logger log = Logger.getLogger(AdapterDeploymentContext.class);
    protected KeycloakDeployment deployment;

    public AdapterDeploymentContext() {
    }

    public AdapterDeploymentContext(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    public KeycloakDeployment resolveDeployment(HttpFacade facade) {
        KeycloakDeployment deployment = this.deployment;
        if (deployment == null) {
            return null;
        }
        if (deployment.getAuthServerBaseUrl() == null) {
            return deployment;
        }
        if (deployment.relativeUrls) {
            deployment = new DeploymentDelegate(this.deployment);
            deployment.setAuthServerBaseUrl(this.getBaseBuilder(facade, this.deployment.getAuthServerBaseUrl()).build(new Object[0]).toString());
        }
        if (deployment.getRealmKey() == null) {
            this.resolveRealmKey(deployment);
        }
        return deployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveRealmKey(KeycloakDeployment deployment) {
        if (deployment.getClient() == null) {
            throw new RuntimeException("KeycloakDeployment was never initialized through appropriate SPIs");
        }
        HttpGet get = new HttpGet(deployment.getRealmInfoUrl());
        try {
            HttpResponse response = deployment.getClient().execute((HttpUriRequest)get);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                this.close(response);
                throw new RuntimeException("Unable to resolve realm public key remotely, status = " + status);
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new RuntimeException("Unable to resolve realm public key remotely.  There was no entity.");
            }
            InputStream is = entity.getContent();
            try {
                int c;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while ((c = is.read()) != -1) {
                    os.write(c);
                }
                byte[] bytes = os.toByteArray();
                String json = new String(bytes);
                PublishedRealmRepresentation rep = (PublishedRealmRepresentation)JsonSerialization.readValue((String)json, PublishedRealmRepresentation.class);
                deployment.setRealmKey(rep.getPublicKey());
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to resolve realm public key remotely", e);
        }
    }

    protected KeycloakUriBuilder getBaseBuilder(HttpFacade facade, String base) {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)base);
        URI request = URI.create(facade.getRequest().getURI());
        String scheme = request.getScheme();
        if (this.deployment.isSslRequired()) {
            scheme = "https";
            if (!request.getScheme().equals(scheme) && request.getPort() != -1) {
                log.error((Object)("request scheme: " + request.getScheme() + " ssl required: " + this.deployment.isSslRequired()));
                throw new RuntimeException("Can't resolve relative url from adapter config.");
            }
        }
        builder.scheme(scheme);
        builder.host(request.getHost());
        if (request.getPort() != -1) {
            builder.port(request.getPort());
        }
        return builder;
    }

    protected void close(HttpResponse response) {
        if (response.getEntity() != null) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void updateDeployment(AdapterConfig config) {
        this.deployment = KeycloakDeploymentBuilder.build(config);
    }

    protected static class DeploymentDelegate
    extends KeycloakDeployment {
        protected KeycloakDeployment delegate;

        public DeploymentDelegate(KeycloakDeployment delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getResourceName() {
            return this.delegate.getResourceName();
        }

        @Override
        public String getRealm() {
            return this.delegate.getRealm();
        }

        @Override
        public void setRealm(String realm) {
            this.delegate.setRealm(realm);
        }

        @Override
        public PublicKey getRealmKey() {
            return this.delegate.getRealmKey();
        }

        @Override
        public void setRealmKey(PublicKey realmKey) {
            this.delegate.setRealmKey(realmKey);
        }

        @Override
        public void setResourceName(String resourceName) {
            this.delegate.setResourceName(resourceName);
        }

        @Override
        public boolean isBearerOnly() {
            return this.delegate.isBearerOnly();
        }

        @Override
        public void setBearerOnly(boolean bearerOnly) {
            this.delegate.setBearerOnly(bearerOnly);
        }

        @Override
        public boolean isPublicClient() {
            return this.delegate.isPublicClient();
        }

        @Override
        public void setPublicClient(boolean publicClient) {
            this.delegate.setPublicClient(publicClient);
        }

        @Override
        public Map<String, String> getResourceCredentials() {
            return this.delegate.getResourceCredentials();
        }

        @Override
        public void setResourceCredentials(Map<String, String> resourceCredentials) {
            this.delegate.setResourceCredentials(resourceCredentials);
        }

        @Override
        public HttpClient getClient() {
            return this.delegate.getClient();
        }

        @Override
        public void setClient(HttpClient client) {
            this.delegate.setClient(client);
        }

        @Override
        public String getScope() {
            return this.delegate.getScope();
        }

        @Override
        public void setScope(String scope) {
            this.delegate.setScope(scope);
        }

        @Override
        public boolean isSslRequired() {
            return this.delegate.isSslRequired();
        }

        @Override
        public void setSslRequired(boolean sslRequired) {
            this.delegate.setSslRequired(sslRequired);
        }

        @Override
        public String getStateCookieName() {
            return this.delegate.getStateCookieName();
        }

        @Override
        public void setStateCookieName(String stateCookieName) {
            this.delegate.setStateCookieName(stateCookieName);
        }

        @Override
        public boolean isUseResourceRoleMappings() {
            return this.delegate.isUseResourceRoleMappings();
        }

        @Override
        public void setUseResourceRoleMappings(boolean useResourceRoleMappings) {
            this.delegate.setUseResourceRoleMappings(useResourceRoleMappings);
        }

        @Override
        public boolean isCors() {
            return this.delegate.isCors();
        }

        @Override
        public void setCors(boolean cors) {
            this.delegate.setCors(cors);
        }

        @Override
        public int getCorsMaxAge() {
            return this.delegate.getCorsMaxAge();
        }

        @Override
        public void setCorsMaxAge(int corsMaxAge) {
            this.delegate.setCorsMaxAge(corsMaxAge);
        }

        @Override
        public String getCorsAllowedHeaders() {
            return this.delegate.getCorsAllowedHeaders();
        }

        @Override
        public void setNotBefore(int notBefore) {
            this.delegate.setNotBefore(notBefore);
        }

        @Override
        public int getNotBefore() {
            return this.delegate.getNotBefore();
        }

        @Override
        public void setExposeToken(boolean exposeToken) {
            this.delegate.setExposeToken(exposeToken);
        }

        @Override
        public boolean isExposeToken() {
            return this.delegate.isExposeToken();
        }

        @Override
        public void setCorsAllowedMethods(String corsAllowedMethods) {
            this.delegate.setCorsAllowedMethods(corsAllowedMethods);
        }

        @Override
        public String getCorsAllowedMethods() {
            return this.delegate.getCorsAllowedMethods();
        }

        @Override
        public void setCorsAllowedHeaders(String corsAllowedHeaders) {
            this.delegate.setCorsAllowedHeaders(corsAllowedHeaders);
        }
    }
}

