/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.PemUtils;

public class KeycloakDeploymentBuilder {
    protected KeycloakDeployment deployment = new KeycloakDeployment();

    protected KeycloakDeploymentBuilder() {
    }

    protected KeycloakDeployment internalBuild(AdapterConfig adapterConfig) {
        if (adapterConfig.getRealm() == null) {
            throw new RuntimeException("Must set 'realm' in config");
        }
        this.deployment.setRealm(adapterConfig.getRealm());
        String resource = adapterConfig.getResource();
        if (resource == null) {
            throw new RuntimeException("Must set 'resource' in config");
        }
        this.deployment.setResourceName(resource);
        String realmKeyPem = adapterConfig.getRealmKey();
        if (realmKeyPem != null) {
            PublicKey realmKey = null;
            try {
                realmKey = PemUtils.decodePublicKey((String)realmKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.deployment.setRealmKey(realmKey);
        }
        this.deployment.setSslRequired(!adapterConfig.isSslNotRequired());
        this.deployment.setResourceCredentials(adapterConfig.getCredentials());
        this.deployment.setPublicClient(adapterConfig.isPublicClient());
        this.deployment.setUseResourceRoleMappings(adapterConfig.isUseResourceRoleMappings());
        if (adapterConfig.isCors()) {
            this.deployment.setCors(true);
            this.deployment.setCorsMaxAge(adapterConfig.getCorsMaxAge());
            this.deployment.setCorsAllowedHeaders(adapterConfig.getCorsAllowedHeaders());
            this.deployment.setCorsAllowedMethods(adapterConfig.getCorsAllowedMethods());
        }
        this.deployment.setBearerOnly(adapterConfig.isBearerOnly());
        if (adapterConfig.isBearerOnly()) {
            // empty if block
        }
        if (realmKeyPem == null && adapterConfig.isBearerOnly() && adapterConfig.getAuthServerUrl() == null) {
            throw new IllegalArgumentException("For bearer auth, you must set the realm-public-key or auth-server-url");
        }
        if (realmKeyPem == null || !this.deployment.isBearerOnly()) {
            this.deployment.setClient(new HttpClientBuilder().build(adapterConfig));
        }
        if (!(adapterConfig.getAuthServerUrl() != null || this.deployment.isBearerOnly() && realmKeyPem != null)) {
            throw new RuntimeException("You must specify auth-url");
        }
        this.deployment.setAuthServerBaseUrl(adapterConfig.getAuthServerUrl());
        return this.deployment;
    }

    public static KeycloakDeployment build(InputStream is) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        AdapterConfig adapterConfig = null;
        try {
            adapterConfig = (AdapterConfig)mapper.readValue(is, AdapterConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new KeycloakDeploymentBuilder().internalBuild(adapterConfig);
    }

    public static KeycloakDeployment build(AdapterConfig adapterConfig) {
        return new KeycloakDeploymentBuilder().internalBuild(adapterConfig);
    }
}

