/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.UserSessionManagement;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.representations.adapters.action.AdminAction;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.SessionStats;
import org.keycloak.representations.adapters.action.SessionStatsAction;
import org.keycloak.representations.adapters.action.UserStats;
import org.keycloak.representations.adapters.action.UserStatsAction;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.StreamUtil;

public class PreAuthActionsHandler {
    private static final Logger log = Logger.getLogger(PreAuthActionsHandler.class);
    protected UserSessionManagement userSessionManagement;
    protected KeycloakDeployment deployment;
    protected HttpFacade facade;

    public PreAuthActionsHandler(UserSessionManagement userSessionManagement, KeycloakDeployment deployment, HttpFacade facade) {
        this.userSessionManagement = userSessionManagement;
        this.deployment = deployment;
        this.facade = facade;
    }

    public boolean handleRequest() {
        String requestUri = this.facade.getRequest().getURI();
        log.debugv("adminRequest {0}", (Object)requestUri);
        if (this.preflightCors()) {
            return true;
        }
        if (requestUri.endsWith("k_logout")) {
            this.handleLogout();
            return true;
        }
        if (requestUri.endsWith("k_push_not_before")) {
            this.handlePushNotBefore();
            return true;
        }
        if (requestUri.endsWith("k_get_session_stats")) {
            this.handleGetSessionStats();
            return true;
        }
        if (requestUri.endsWith("k_get_user_stats")) {
            this.handleGetUserStats();
            return true;
        }
        return false;
    }

    public boolean preflightCors() {
        String allowHeaders;
        log.debugv("checkCorsPreflight {0}", (Object)this.facade.getRequest().getURI());
        if (!this.facade.getRequest().getMethod().equalsIgnoreCase("OPTIONS")) {
            return false;
        }
        if (this.facade.getRequest().getHeader("Origin") == null) {
            log.debug((Object)"checkCorsPreflight: no origin header");
            return false;
        }
        log.debug((Object)"Preflight request returning");
        this.facade.getResponse().setStatus(200);
        String origin = this.facade.getRequest().getHeader("Origin");
        this.facade.getResponse().setHeader("Access-Control-Allow-Origin", origin);
        this.facade.getResponse().setHeader("Access-Control-Allow-Credentials", "true");
        String requestMethods = this.facade.getRequest().getHeader("Access-Control-Request-Method");
        if (requestMethods != null) {
            if (this.deployment.getCorsAllowedMethods() != null) {
                requestMethods = this.deployment.getCorsAllowedMethods();
            }
            this.facade.getResponse().setHeader("Access-Control-Allow-Methods", requestMethods);
        }
        if ((allowHeaders = this.facade.getRequest().getHeader("Access-Control-Request-Headers")) != null) {
            if (this.deployment.getCorsAllowedHeaders() != null) {
                allowHeaders = this.deployment.getCorsAllowedHeaders();
            }
            this.facade.getResponse().setHeader("Access-Control-Allow-Headers", allowHeaders);
        }
        if (this.deployment.getCorsMaxAge() > -1) {
            this.facade.getResponse().setHeader("Access-Control-Max-Age", Integer.toString(this.deployment.getCorsMaxAge()));
        }
        return true;
    }

    protected void handleLogout() {
        log.info((Object)"K_LOGOUT sent");
        try {
            JWSInput token = this.verifyAdminRequest();
            if (token == null) {
                return;
            }
            LogoutAction action = (LogoutAction)JsonSerialization.readValue((byte[])token.getContent(), LogoutAction.class);
            if (!this.validateAction((AdminAction)action)) {
                return;
            }
            String user = action.getUser();
            if (user != null) {
                log.info((Object)("logout of session for: " + user));
                this.userSessionManagement.logout(user);
            } else {
                log.info((Object)"logout of all sessions");
                if (action.getNotBefore() > this.deployment.getNotBefore()) {
                    this.deployment.setNotBefore(action.getNotBefore());
                }
                this.userSessionManagement.logoutAll();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void handlePushNotBefore() {
        log.info((Object)"K_PUSH_NOT_BEFORE sent");
        try {
            JWSInput token = this.verifyAdminRequest();
            if (token == null) {
                return;
            }
            PushNotBeforeAction action = (PushNotBeforeAction)JsonSerialization.readValue((byte[])token.getContent(), PushNotBeforeAction.class);
            if (!this.validateAction((AdminAction)action)) {
                return;
            }
            this.deployment.setNotBefore(action.getNotBefore());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected JWSInput verifyAdminRequest() throws Exception {
        String token = StreamUtil.readString((InputStream)this.facade.getRequest().getInputStream());
        if (token == null) {
            log.warn((Object)"admin request failed, no token");
            this.facade.getResponse().sendError(403, "no token");
            return null;
        }
        JWSInput input = new JWSInput(token);
        boolean verified = false;
        try {
            verified = RSAProvider.verify((JWSInput)input, (PublicKey)this.deployment.getRealmKey());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (!verified) {
            log.warn((Object)"admin request failed, unable to verify token");
            this.facade.getResponse().sendError(403, "no token");
            return null;
        }
        return input;
    }

    protected boolean validateAction(AdminAction action) {
        if (!action.validate()) {
            log.warn((Object)("admin request failed, not validated" + action.getAction()));
            this.facade.getResponse().sendError(400, "Not validated");
            return false;
        }
        if (action.isExpired()) {
            log.warn((Object)"admin request failed, expired token");
            this.facade.getResponse().sendError(400, "Expired token");
            return false;
        }
        if (!this.deployment.getResourceName().equals(action.getResource())) {
            log.warn((Object)"Resource name does not match");
            this.facade.getResponse().sendError(400, "Resource name does not match");
            return false;
        }
        return true;
    }

    protected void handleGetSessionStats() {
        log.info((Object)"K_GET_SESSION_STATS sent");
        try {
            JWSInput token = this.verifyAdminRequest();
            if (token == null) {
                return;
            }
            SessionStatsAction action = (SessionStatsAction)JsonSerialization.readValue((byte[])token.getContent(), SessionStatsAction.class);
            if (!this.validateAction((AdminAction)action)) {
                return;
            }
            SessionStats stats = new SessionStats();
            stats.setActiveSessions(this.userSessionManagement.getActiveSessions());
            stats.setActiveUsers(this.userSessionManagement.getActiveUsers().size());
            if (action.isListUsers() && this.userSessionManagement.getActiveSessions() > 0) {
                HashMap<String, UserStats> list = new HashMap<String, UserStats>();
                for (String user : this.userSessionManagement.getActiveUsers()) {
                    list.put(user, this.getUserStats(user));
                }
                stats.setUsers(list);
            }
            this.facade.getResponse().setStatus(200);
            this.facade.getResponse().setHeader("Content-Type", "application/json");
            JsonSerialization.writeValueToStream((OutputStream)this.facade.getResponse().getOutputStream(), (Object)stats);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void handleGetUserStats() {
        log.info((Object)"K_GET_USER_STATS sent");
        try {
            JWSInput token = this.verifyAdminRequest();
            if (token == null) {
                return;
            }
            UserStatsAction action = (UserStatsAction)JsonSerialization.readValue((byte[])token.getContent(), UserStatsAction.class);
            if (!this.validateAction((AdminAction)action)) {
                return;
            }
            String user = action.getUser();
            UserStats stats = this.getUserStats(user);
            this.facade.getResponse().setStatus(200);
            this.facade.getResponse().setHeader("Content-Type", "application/json");
            JsonSerialization.writeValueToStream((OutputStream)this.facade.getResponse().getOutputStream(), (Object)stats);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected UserStats getUserStats(String user) {
        UserStats stats = new UserStats();
        Long loginTime = this.userSessionManagement.getUserLoginTime(user);
        if (loginTime != null) {
            stats.setLoggedIn(true);
            stats.setWhenLoggedIn(loginTime.longValue());
        } else {
            stats.setLoggedIn(false);
        }
        return stats;
    }
}

