/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.KeycloakUriBuilder;
import org.keycloak.util.PemUtils;

public class KeycloakDeploymentBuilder {
    protected KeycloakDeployment deployment = new KeycloakDeployment();

    protected KeycloakDeploymentBuilder() {
    }

    protected KeycloakDeployment internalBuild(AdapterConfig adapterConfig) {
        if (adapterConfig.getRealm() == null) {
            throw new RuntimeException("Must set 'realm' in config");
        }
        this.deployment.setRealm(adapterConfig.getRealm());
        String resource = adapterConfig.getResource();
        if (resource == null) {
            throw new RuntimeException("Must set 'resource' in config");
        }
        this.deployment.setResourceName(resource);
        String realmKeyPem = adapterConfig.getRealmKey();
        if (realmKeyPem == null) {
            throw new IllegalArgumentException("You must set the realm-public-key");
        }
        PublicKey realmKey = null;
        try {
            realmKey = PemUtils.decodePublicKey((String)realmKeyPem);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.deployment.setRealmKey(realmKey);
        this.deployment.setSslRequired(!adapterConfig.isSslNotRequired());
        this.deployment.setResourceCredentials(adapterConfig.getCredentials());
        this.deployment.setPublicClient(adapterConfig.isPublicClient());
        this.deployment.setUseResourceRoleMappings(adapterConfig.isUseResourceRoleMappings());
        if (adapterConfig.isBearerOnly()) {
            this.deployment.setBearerOnly(true);
            return this.deployment;
        }
        this.deployment.setClient(new HttpClientBuilder().build(adapterConfig));
        if (adapterConfig.getAuthServerUrl() == null) {
            throw new RuntimeException("You must specify auth-url");
        }
        KeycloakUriBuilder serverBuilder = KeycloakUriBuilder.fromUri((String)adapterConfig.getAuthServerUrl());
        String authUrl = serverBuilder.clone().path("/rest/realms/{realm-name}/tokens/login").build(new Object[]{adapterConfig.getRealm()}).toString();
        String tokenUrl = serverBuilder.clone().path("/rest/realms/{realm-name}/tokens/access/codes").build(new Object[]{adapterConfig.getRealm()}).toString();
        String refreshUrl = serverBuilder.clone().path("/rest/realms/{realm-name}/tokens/refresh").build(new Object[]{adapterConfig.getRealm()}).toString();
        this.deployment.setAuthUrl(KeycloakUriBuilder.fromUri((String)authUrl).queryParam("client_id", new Object[]{this.deployment.getResourceName()}));
        this.deployment.setCodeUrl(tokenUrl);
        this.deployment.setRefreshUrl(refreshUrl);
        return this.deployment;
    }

    public static KeycloakDeployment build(InputStream is) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        AdapterConfig adapterConfig = null;
        try {
            adapterConfig = (AdapterConfig)mapper.readValue(is, AdapterConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new KeycloakDeploymentBuilder().internalBuild(adapterConfig);
    }

    public static KeycloakDeployment build(AdapterConfig adapterConfig) {
        return new KeycloakDeploymentBuilder().internalBuild(adapterConfig);
    }
}

