/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.ProxyConfig;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientProxy;
import org.jboss.resteasy.client.jaxrs.internal.proxy.MethodInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ResteasyClientProxy;
import org.jboss.resteasy.client.jaxrs.internal.proxy.SubResourceInvoker;
import org.jboss.resteasy.util.IsHttpMethod;

public class ProxyBuilder<T> {
    private static final Class<?>[] cClassArgArray = new Class[]{Class.class};
    private final Class<T> iface;
    private final ResteasyWebTarget webTarget;
    private ClassLoader loader = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    });
    private MediaType serverConsumes;
    private MediaType serverProduces;

    public static <T> ProxyBuilder<T> builder(Class<T> iface, WebTarget webTarget) {
        return new ProxyBuilder<T>(iface, (ResteasyWebTarget)webTarget);
    }

    public static <T> T proxy(Class<T> iface, WebTarget base, ProxyConfig config) {
        Path path;
        if (iface.isAnnotationPresent(Path.class) && !(path = iface.getAnnotation(Path.class)).value().equals("") && !path.value().equals("/")) {
            base = base.path(path.value());
        }
        HashMap<Method, MethodInvoker> methodMap = new HashMap<Method, MethodInvoker>();
        for (Method method : iface.getMethods()) {
            MethodInvoker invoker;
            if ("as".equals(method.getName()) && Arrays.equals(method.getParameterTypes(), cClassArgArray)) continue;
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if ((httpMethods == null || httpMethods.size() == 0) && method.isAnnotationPresent(Path.class) && method.getReturnType().isInterface()) {
                invoker = new SubResourceInvoker((ResteasyWebTarget)base, method, config);
            } else {
                if (httpMethods == null) continue;
                invoker = ProxyBuilder.createClientInvoker(iface, method, (ResteasyWebTarget)base, config);
            }
            methodMap.put(method, invoker);
        }
        Class[] intfs = new Class[]{iface, ResteasyClientProxy.class};
        ClientProxy clientProxy = new ClientProxy(methodMap, base, config);
        clientProxy.setClazz(iface);
        ClassLoader cl = config.getLoader();
        try {
            cl.loadClass(iface.getName());
        }
        catch (Throwable t) {
            cl = new DelegateClassLoader(iface.getClassLoader(), cl);
        }
        return (T)Proxy.newProxyInstance(cl, intfs, (InvocationHandler)clientProxy);
    }

    private static <T> ClientInvoker createClientInvoker(Class<T> clazz, Method method, ResteasyWebTarget base, ProxyConfig config) {
        Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
        if (httpMethods == null || httpMethods.size() != 1) {
            throw new RuntimeException(Messages.MESSAGES.mustUseExactlyOneHttpMethod(method.toString()));
        }
        ClientInvoker invoker = new ClientInvoker(base, clazz, method, config);
        invoker.setHttpMethod(httpMethods.iterator().next());
        return invoker;
    }

    private ProxyBuilder(Class<T> iface, ResteasyWebTarget webTarget) {
        this.iface = iface;
        this.webTarget = webTarget;
    }

    public ProxyBuilder<T> classloader(ClassLoader cl) {
        this.loader = cl;
        return this;
    }

    public ProxyBuilder<T> defaultProduces(MediaType type) {
        this.serverProduces = type;
        return this;
    }

    public ProxyBuilder<T> defaultConsumes(MediaType type) {
        this.serverConsumes = type;
        return this;
    }

    public ProxyBuilder<T> defaultProduces(String type) {
        this.serverProduces = MediaType.valueOf(type);
        return this;
    }

    public ProxyBuilder<T> defaultConsumes(String type) {
        this.serverConsumes = MediaType.valueOf(type);
        return this;
    }

    public T build() {
        return ProxyBuilder.proxy(this.iface, this.webTarget, new ProxyConfig(this.loader, this.serverConsumes, this.serverProduces));
    }

    public static class DelegateClassLoader
    extends SecureClassLoader {
        private final ClassLoader delegate;
        private final ClassLoader parent;

        public DelegateClassLoader(ClassLoader delegate, ClassLoader parent) {
            super(parent);
            this.delegate = delegate;
            this.parent = parent;
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            if (this.parent != null) {
                try {
                    return this.parent.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return this.delegate.loadClass(className);
        }

        @Override
        public URL getResource(String name) {
            URL url = null;
            if (this.parent != null) {
                url = this.parent.getResource(name);
            }
            return url == null ? this.delegate.getResource(name) : url;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final ArrayList<Enumeration<URL>> foundResources = new ArrayList<Enumeration<URL>>();
            foundResources.add(this.delegate.getResources(name));
            if (this.parent != null) {
                foundResources.add(this.parent.getResources(name));
            }
            return new Enumeration<URL>(){
                private int position;
                {
                    this.position = foundResources.size() - 1;
                }

                @Override
                public boolean hasMoreElements() {
                    while (this.position >= 0) {
                        if (((Enumeration)foundResources.get(this.position)).hasMoreElements()) {
                            return true;
                        }
                        --this.position;
                    }
                    return false;
                }

                @Override
                public URL nextElement() {
                    while (this.position >= 0) {
                        try {
                            return (URL)((Enumeration)foundResources.get(this.position)).nextElement();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            --this.position;
                        }
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream is = null;
            if (this.parent != null) {
                is = this.parent.getResourceAsStream(name);
            }
            return is == null ? this.delegate.getResourceAsStream(name) : is;
        }
    }
}

