/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.provider;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.representations.provider.ScriptProviderMetadata;

public class ScriptProviderDescriptor {
    public static final String AUTHENTICATORS = "authenticators";
    public static final String POLICIES = "policies";
    public static final String MAPPERS = "mappers";
    private Map<String, List<ScriptProviderMetadata>> providers = new HashMap<String, List<ScriptProviderMetadata>>();

    @JsonUnwrapped
    @JsonGetter
    public Map<String, List<ScriptProviderMetadata>> getProviders() {
        return this.providers;
    }

    @JsonSetter
    public void setAuthenticators(List<ScriptProviderMetadata> metadata) {
        this.providers.put(AUTHENTICATORS, metadata);
    }

    @JsonSetter
    public void setPolicies(List<ScriptProviderMetadata> metadata) {
        this.providers.put(POLICIES, metadata);
    }

    @JsonSetter
    public void setMappers(List<ScriptProviderMetadata> metadata) {
        this.providers.put(MAPPERS, metadata);
    }

    public void addAuthenticator(String name, String fileName) {
        this.addProvider(AUTHENTICATORS, name, fileName, null);
    }

    private void addProvider(String type, String name, String fileName, String description) {
        List<ScriptProviderMetadata> authenticators = this.providers.get(type);
        if (authenticators == null) {
            authenticators = new ArrayList<ScriptProviderMetadata>();
            this.providers.put(type, authenticators);
        }
        authenticators.add(new ScriptProviderMetadata(name, fileName, description));
    }

    public void addPolicy(String name, String fileName) {
        this.addProvider(POLICIES, name, fileName, null);
    }

    public void addMapper(String name, String fileName) {
        this.addProvider(MAPPERS, name, fileName, null);
    }
}

