/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import java.security.PublicKey;
import java.security.Signature;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureVerifierContext;

public class AsymmetricSignatureVerifierContext
implements SignatureVerifierContext {
    private final KeyWrapper key;

    public AsymmetricSignatureVerifierContext(KeyWrapper key) {
        this.key = key;
    }

    @Override
    public String getKid() {
        return this.key.getKid();
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws VerificationException {
        try {
            Signature verifier = Signature.getInstance(JavaAlgorithm.getJavaAlgorithm(this.key.getAlgorithm()));
            verifier.initVerify((PublicKey)this.key.getVerifyKey());
            verifier.update(data);
            return verifier.verify(signature);
        }
        catch (Exception e) {
            throw new VerificationException("Signing failed", e);
        }
    }
}

