/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse.client;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.InboundSseEvent;
import javax.ws.rs.sse.SseEventSource;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.plugins.providers.sse.SseEventInputImpl;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class SseEventSourceImpl
implements SseEventSource {
    public static final long RECONNECT_DEFAULT = 500L;
    private final WebTarget target;
    private final long reconnectDelay;
    private final ScheduledExecutorService executor;
    private final AtomicReference<State> state = new AtomicReference<State>(State.PENDING);
    private final List<Consumer<InboundSseEvent>> onEventConsumers = new CopyOnWriteArrayList<Consumer<InboundSseEvent>>();
    private final List<Consumer<Throwable>> onErrorConsumers = new CopyOnWriteArrayList<Consumer<Throwable>>();
    private final List<Runnable> onCompleteConsumers = new CopyOnWriteArrayList<Runnable>();
    private boolean alwaysReconnect;
    private volatile ClientResponse response;

    public SseEventSourceImpl(WebTarget target) {
        this(target, true);
    }

    public SseEventSourceImpl(WebTarget target, boolean open) {
        this(target, null, 500L, open, null);
    }

    private SseEventSourceImpl(WebTarget target, String name, long reconnectDelay, boolean open, ScheduledExecutorService executor) {
        if (target == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.webTargetIsNotSetForEventSource());
        }
        this.target = target;
        this.reconnectDelay = reconnectDelay;
        this.alwaysReconnect = true;
        if (name == null) {
            name = String.format("sse-event-source(%s)", target.getUri());
        }
        if (executor == null) {
            ScheduledExecutorService scheduledExecutor = null;
            if (target instanceof ResteasyWebTarget) {
                scheduledExecutor = ((ResteasyWebTarget)target).getResteasyClient().getScheduledExecutor();
            }
            this.executor = scheduledExecutor != null ? scheduledExecutor : Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(name));
        } else {
            this.executor = executor;
        }
        if (open) {
            this.open();
        }
    }

    @Override
    public void open() {
        this.open(null);
    }

    public void open(String lastEventId) {
        this.open(lastEventId, "GET", null, MediaType.SERVER_SENT_EVENTS_TYPE);
    }

    public void open(String lastEventId, String verb, Entity<?> entity, MediaType ... mediaTypes) {
        if (!this.state.compareAndSet(State.PENDING, State.OPEN)) {
            throw new IllegalStateException(Messages.MESSAGES.eventSourceIsNotReadyForOpen());
        }
        EventHandler handler = new EventHandler(this.reconnectDelay, lastEventId, verb, entity, mediaTypes);
        this.executor.submit(handler);
        handler.awaitConnected();
    }

    @Override
    public boolean isOpen() {
        return this.state.get() == State.OPEN;
    }

    @Override
    public void register(Consumer<InboundSseEvent> onEvent) {
        if (onEvent == null) {
            throw new IllegalArgumentException();
        }
        this.onEventConsumers.add(onEvent);
    }

    @Override
    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError) {
        if (onEvent == null) {
            throw new IllegalArgumentException();
        }
        if (onError == null) {
            throw new IllegalArgumentException();
        }
        this.onEventConsumers.add(onEvent);
        this.onErrorConsumers.add(onError);
    }

    @Override
    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError, Runnable onComplete) {
        if (onEvent == null) {
            throw new IllegalArgumentException();
        }
        if (onError == null) {
            throw new IllegalArgumentException();
        }
        if (onComplete == null) {
            throw new IllegalArgumentException();
        }
        this.onEventConsumers.add(onEvent);
        this.onErrorConsumers.add(onError);
        this.onCompleteConsumers.add(onComplete);
    }

    @Override
    public boolean close(long timeout, TimeUnit unit) {
        this.internalClose();
        try {
            if (!this.executor.awaitTermination(timeout, unit)) {
                return false;
            }
        }
        catch (InterruptedException e) {
            this.onErrorConsumers.forEach(consumer -> consumer.accept(e));
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    private void internalClose() {
        if (this.state.getAndSet(State.CLOSED) == State.CLOSED) {
            return;
        }
        if (this.response != null) {
            try {
                this.response.releaseConnection(false);
            }
            catch (IOException e) {
                this.onErrorConsumers.forEach(consumer -> consumer.accept(e));
            }
        }
        this.executor.shutdownNow();
        this.onCompleteConsumers.forEach(Runnable::run);
    }

    @Deprecated
    public void setAlwasyReconnect(boolean always) {
        this.setAlwaysReconnect(always);
    }

    public void setAlwaysReconnect(boolean always) {
        this.alwaysReconnect = always;
    }

    private class EventHandler
    implements Runnable {
        private final CountDownLatch connectedLatch;
        private String lastEventId;
        private long reconnectDelay;
        private String verb;
        private Entity<?> entity;
        private MediaType[] mediaTypes;

        public EventHandler(long reconnectDelay, String lastEventId, String verb, Entity<?> entity, MediaType ... mediaTypes) {
            this.connectedLatch = new CountDownLatch(1);
            this.reconnectDelay = reconnectDelay;
            this.lastEventId = lastEventId;
            this.verb = verb;
            this.entity = entity;
            this.mediaTypes = mediaTypes;
        }

        private EventHandler(EventHandler anotherHandler) {
            this.connectedLatch = anotherHandler.connectedLatch;
            this.reconnectDelay = anotherHandler.reconnectDelay;
            this.lastEventId = anotherHandler.lastEventId;
            this.verb = anotherHandler.verb;
            this.entity = anotherHandler.entity;
            this.mediaTypes = anotherHandler.mediaTypes;
        }

        @Override
        public void run() {
            if (SseEventSourceImpl.this.state.get() != State.OPEN) {
                return;
            }
            SseEventInputImpl eventInput = null;
            long delay = this.reconnectDelay;
            try {
                Invocation.Builder requestBuilder = this.buildRequest(this.mediaTypes);
                Invocation request = null;
                request = this.entity == null ? requestBuilder.build(this.verb) : requestBuilder.build(this.verb, this.entity);
                SseEventSourceImpl.this.response = (ClientResponse)request.invoke();
                if (Response.Status.Family.SUCCESSFUL.equals((Object)SseEventSourceImpl.this.response.getStatusInfo().getFamily())) {
                    this.onConnection();
                    eventInput = SseEventSourceImpl.this.response.readEntity(SseEventInputImpl.class);
                    if (eventInput == null && !SseEventSourceImpl.this.alwaysReconnect) {
                        SseEventSourceImpl.this.internalClose();
                    }
                } else {
                    SseEventSourceImpl.this.response.bufferEntity();
                    ClientInvocation.handleErrorStatus(SseEventSourceImpl.this.response);
                }
            }
            catch (ServiceUnavailableException ex) {
                if (ex.hasRetryAfter()) {
                    this.onConnection();
                    Date requestTime = new Date();
                    delay = ex.getRetryTime(requestTime).getTime() - requestTime.getTime();
                    SseEventSourceImpl.this.onErrorConsumers.forEach(consumer -> consumer.accept(ex));
                } else {
                    this.onUnrecoverableError(ex);
                }
            }
            catch (Throwable e) {
                this.onUnrecoverableError(e);
            }
            while (!Thread.currentThread().isInterrupted() && SseEventSourceImpl.this.state.get() == State.OPEN) {
                if (eventInput == null || eventInput.isClosed()) {
                    this.reconnect(delay);
                    break;
                }
                try {
                    InboundSseEvent event = eventInput.read();
                    if (event != null) {
                        this.onEvent(event);
                        if (event.isReconnectDelaySet()) {
                            delay = event.getReconnectDelay();
                        }
                        SseEventSourceImpl.this.onEventConsumers.forEach(consumer -> consumer.accept(event));
                        continue;
                    }
                    if (SseEventSourceImpl.this.alwaysReconnect) continue;
                    SseEventSourceImpl.this.internalClose();
                }
                catch (IOException e) {
                    this.reconnect(delay);
                }
                break;
            }
        }

        public void awaitConnected() {
            try {
                this.connectedLatch.await();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        private void onConnection() {
            this.connectedLatch.countDown();
        }

        private void onUnrecoverableError(Throwable throwable) {
            this.connectedLatch.countDown();
            SseEventSourceImpl.this.onErrorConsumers.forEach(consumer -> consumer.accept(throwable));
            SseEventSourceImpl.this.internalClose();
        }

        private void onEvent(InboundSseEvent event) {
            if (event == null) {
                return;
            }
            if (event.getId() != null) {
                this.lastEventId = event.getId();
            }
        }

        private Invocation.Builder buildRequest(MediaType ... mediaTypes) {
            Invocation.Builder request;
            Invocation.Builder builder = request = mediaTypes != null && mediaTypes.length > 0 ? SseEventSourceImpl.this.target.request(mediaTypes) : SseEventSourceImpl.this.target.request();
            if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                request.header("Last-Event-ID", this.lastEventId);
            }
            return request;
        }

        private void reconnect(long delay) {
            if (SseEventSourceImpl.this.state.get() != State.OPEN) {
                return;
            }
            EventHandler processor = new EventHandler(this);
            if (delay > 0L) {
                SseEventSourceImpl.this.executor.schedule(processor, delay, TimeUnit.MILLISECONDS);
            } else {
                SseEventSourceImpl.this.executor.submit(processor);
            }
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DaemonThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            return t;
        }
    }

    public static class SourceBuilder
    extends SseEventSource.Builder {
        private WebTarget target = null;
        private long reconnect = 500L;
        private String name = null;
        private ScheduledExecutorService executor;

        public SseEventSource.Builder named(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SseEventSource build() {
            return new SseEventSourceImpl(this.target, this.name, this.reconnect, false, this.executor);
        }

        @Override
        public SseEventSource.Builder target(WebTarget target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
            return this;
        }

        @Override
        public SseEventSource.Builder reconnectingEvery(long delay, TimeUnit unit) {
            this.reconnect = unit.toMillis(delay);
            return this;
        }

        public SseEventSource.Builder executor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }
    }

    private static enum State {
        PENDING,
        OPEN,
        CLOSED;

    }
}

