/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.UnhandledException;

public class SynchronousExecutionContext
extends AbstractExecutionContext {
    protected final CountDownLatch syncLatch = new CountDownLatch(1);
    protected long timeout;
    protected TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    protected boolean wasSuspended;
    protected volatile boolean done;
    protected Object responseLock = new Object();
    protected ResteasyAsynchronousResponse asynchronousResponse;

    public SynchronousExecutionContext(SynchronousDispatcher dispatcher, HttpRequest request, HttpResponse response) {
        super(dispatcher, request, response);
    }

    @Override
    public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
        return this.suspend(-1L);
    }

    @Override
    public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
        return this.suspend(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
        this.wasSuspended = true;
        this.asynchronousResponse = new SynchronousAsynchronousResponse(this.dispatcher, this.request, this.response);
        this.asynchronousResponse.setTimeout(time, unit);
        return this.asynchronousResponse;
    }

    @Override
    public ResteasyAsynchronousResponse getAsyncResponse() {
        return this.asynchronousResponse;
    }

    @Override
    public boolean isSuspended() {
        return this.wasSuspended;
    }

    protected class SynchronousAsynchronousResponse
    extends AbstractAsynchronousResponse {
        protected boolean cancelled;

        public SynchronousAsynchronousResponse(SynchronousDispatcher dispatcher, HttpRequest request, HttpResponse response) {
            super(dispatcher, request, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean resume(Object entity) {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                boolean bl;
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                if (this.cancelled) {
                    return false;
                }
                try {
                    bl = this.internalResume(entity);
                    SynchronousExecutionContext.this.done = true;
                    SynchronousExecutionContext.this.syncLatch.countDown();
                }
                catch (Throwable throwable) {
                    SynchronousExecutionContext.this.done = true;
                    SynchronousExecutionContext.this.syncLatch.countDown();
                    throw throwable;
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean resume(Throwable exc) throws IllegalStateException {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                boolean bl;
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                if (this.cancelled) {
                    return false;
                }
                try {
                    bl = this.internalResume(exc);
                    SynchronousExecutionContext.this.done = true;
                    SynchronousExecutionContext.this.syncLatch.countDown();
                }
                catch (Throwable throwable) {
                    SynchronousExecutionContext.this.done = true;
                    SynchronousExecutionContext.this.syncLatch.countDown();
                    throw throwable;
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initialRequestThreadFinished() {
            if (!SynchronousExecutionContext.this.wasSuspended) {
                return;
            }
            boolean result = false;
            try {
                if (SynchronousExecutionContext.this.timeout <= 0L) {
                    SynchronousExecutionContext.this.syncLatch.await();
                    result = true;
                } else {
                    result = SynchronousExecutionContext.this.syncLatch.await(SynchronousExecutionContext.this.timeout, SynchronousExecutionContext.this.timeoutUnit);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!result) {
                Object object = SynchronousExecutionContext.this.responseLock;
                synchronized (object) {
                    if (!SynchronousExecutionContext.this.done) {
                        if (this.timeoutHandler != null) {
                            this.timeoutHandler.handleTimeout(this);
                        }
                        if (!SynchronousExecutionContext.this.done) {
                            try {
                                this.internalResume(Response.status(503).build());
                            }
                            catch (Exception e) {
                                throw new UnhandledException(e);
                            }
                            finally {
                                SynchronousExecutionContext.this.done = true;
                            }
                        }
                    }
                }
            }
        }

        @Override
        public boolean setTimeout(long time, TimeUnit unit) throws IllegalStateException {
            SynchronousExecutionContext.this.timeout = time;
            SynchronousExecutionContext.this.timeoutUnit = unit;
            return !SynchronousExecutionContext.this.done && !this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (this.cancelled) {
                    return true;
                }
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                SynchronousExecutionContext.this.done = true;
                this.cancelled = true;
            }
            return this.internalResume(Response.status(Response.Status.SERVICE_UNAVAILABLE).build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(int retryAfter) {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (this.cancelled) {
                    return true;
                }
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                SynchronousExecutionContext.this.done = true;
                this.cancelled = true;
            }
            return this.internalResume(Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(Date retryAfter) {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (this.cancelled) {
                    return true;
                }
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                SynchronousExecutionContext.this.done = true;
                this.cancelled = true;
            }
            return this.internalResume(Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build());
        }

        @Override
        public boolean isSuspended() {
            return !SynchronousExecutionContext.this.done;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return SynchronousExecutionContext.this.done;
        }
    }
}

