/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class HttpServletResponseHeaders
implements MultivaluedMap<String, Object> {
    private CaseInsensitiveMap cachedHeaders = new CaseInsensitiveMap();
    private HttpServletResponse response;
    private ResteasyProviderFactory factory;

    public HttpServletResponseHeaders(HttpServletResponse response, ResteasyProviderFactory factory) {
        this.response = response;
        this.factory = factory;
    }

    @Override
    public void addAll(String key, Object ... newValues) {
        for (Object value : newValues) {
            this.add(key, value);
        }
    }

    @Override
    public void addAll(String key, List<Object> valueList) {
        for (Object value : valueList) {
            this.add(key, value);
        }
    }

    @Override
    public void addFirst(String key, Object value) {
        Object list = this.get(key);
        if (list == null) {
            this.add(key, value);
            return;
        }
        list.add(0, value);
    }

    @Override
    public void putSingle(String key, Object value) {
        this.cachedHeaders.putSingle(key, value);
        RuntimeDelegate.HeaderDelegate delegate = this.factory.getHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.response.setHeader(key, delegate.toString(value));
        } else {
            this.response.setHeader(key, value.toString());
        }
    }

    @Override
    public void add(String key, Object value) {
        this.cachedHeaders.add(key, value);
        this.addResponseHeader(key, value);
    }

    protected void addResponseHeader(String key, Object value) {
        RuntimeDelegate.HeaderDelegate delegate = this.factory.getHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.response.addHeader(key, delegate.toString(value));
        } else {
            this.response.addHeader(key, value.toString());
        }
    }

    @Override
    public Object getFirst(String key) {
        return this.cachedHeaders.getFirst(key);
    }

    @Override
    public int size() {
        return this.cachedHeaders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cachedHeaders.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.cachedHeaders.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.cachedHeaders.containsValue(o);
    }

    @Override
    public List<Object> get(Object o) {
        return this.cachedHeaders.get(o);
    }

    @Override
    public List<Object> put(String s, List<Object> objs) {
        for (Object obj : objs) {
            this.addResponseHeader(s, obj);
        }
        return this.cachedHeaders.put(s, objs);
    }

    @Override
    public List<Object> remove(Object o) {
        throw new RuntimeException(Messages.MESSAGES.removingHeaderIllegal());
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<Object>> map) {
        for (Map.Entry<? extends String, ? extends List<Object>> entry : map.entrySet()) {
            List<Object> objs = entry.getValue();
            if (objs.isEmpty()) continue;
            this.putResponseHeader(entry.getKey(), objs.get(0));
            for (int i = 1; i < objs.size(); ++i) {
                this.add(entry.getKey(), objs.get(i));
            }
        }
    }

    protected void putResponseHeader(String key, Object value) {
        RuntimeDelegate.HeaderDelegate delegate = this.factory.getHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.response.setHeader(key, delegate.toString(value));
        } else {
            this.response.setHeader(key, value.toString());
        }
        this.cachedHeaders.add(key, value);
    }

    @Override
    public void clear() {
        throw new RuntimeException(Messages.MESSAGES.removingHeaderIllegal());
    }

    @Override
    public Set<String> keySet() {
        return this.cachedHeaders.keySet();
    }

    @Override
    public Collection<List<Object>> values() {
        return this.cachedHeaders.values();
    }

    @Override
    public Set<Map.Entry<String, List<Object>>> entrySet() {
        return this.cachedHeaders.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.cachedHeaders.equals(o);
    }

    @Override
    public int hashCode() {
        return this.cachedHeaders.hashCode();
    }

    @Override
    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, Object> otherMap) {
        return this.cachedHeaders.equalsIgnoreValueOrder(otherMap);
    }
}

