/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.LinkImpl;

public class LinkBuilderImpl
implements Link.Builder {
    protected final Map<String, String> map = new HashMap<String, String>();
    protected UriBuilder uriBuilder;
    protected URI baseUri;

    @Override
    public Link.Builder link(Link link) {
        this.uriBuilder = UriBuilder.fromUri(link.getUri());
        this.map.clear();
        this.map.putAll(link.getParams());
        return this;
    }

    @Override
    public Link.Builder link(String link) {
        Link l = LinkImpl.valueOf(link);
        return this.link(l);
    }

    @Override
    public Link.Builder uriBuilder(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder.clone();
        return this;
    }

    @Override
    public Link.Builder uri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.uriParamNull());
        }
        this.uriBuilder = UriBuilder.fromUri(uri);
        return this;
    }

    @Override
    public Link.Builder uri(String uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.uriParamNull());
        }
        this.uriBuilder = UriBuilder.fromUri(uri);
        return this;
    }

    @Override
    public Link.Builder rel(String rel) {
        if (rel == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.relParamNull());
        }
        String rels = this.map.get("rel");
        this.param("rel", rels == null ? rel : rels + " " + rel);
        return this;
    }

    @Override
    public Link.Builder title(String title) {
        if (title == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.titleParamNull());
        }
        this.param("title", title);
        return this;
    }

    @Override
    public Link.Builder type(String type) {
        if (type == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.typeParamNull());
        }
        this.param("type", type);
        return this;
    }

    @Override
    public Link.Builder param(String name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.nameParamWasNull());
        }
        if (value == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.valueParamWasNull());
        }
        this.map.put(name, value);
        return this;
    }

    @Override
    public Link build(Object ... values) throws UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.valuesParamWasNull());
        }
        URI built = null;
        built = this.uriBuilder == null ? this.baseUri : this.uriBuilder.build(values);
        if (!built.isAbsolute() && this.baseUri != null) {
            built = this.baseUri.resolve(built);
        }
        return new LinkImpl(built, this.map);
    }

    @Override
    public Link buildRelativized(URI uri, Object ... values) {
        URI built;
        if (uri == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.uriParamNull());
        }
        if (values == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.valuesParamWasNull());
        }
        URI with = built = this.uriBuilder.build(values);
        if (this.baseUri != null) {
            with = this.baseUri.resolve(built);
        }
        return new LinkImpl(uri.relativize(with), this.map);
    }

    @Override
    public Link.Builder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    @Override
    public Link.Builder baseUri(String uri) {
        this.baseUri = URI.create(uri);
        return this;
    }
}

